// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for ComputeNodeDeallocateOption.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum ComputeNodeDeallocateOption
    {
        /// <summary>
        /// Terminate running Task processes and requeue the Tasks. The Tasks
        /// will run again when a Compute Node is available. Deallocate the
        /// Compute Node as soon as Tasks have been terminated.
        /// </summary>
        [EnumMember(Value = "requeue")]
        Requeue,
        /// <summary>
        /// Terminate running Tasks. The Tasks will be completed with
        /// failureInfo indicating that they were terminated, and will not run
        /// again. Deallocate the Compute Node as soon as Tasks have been
        /// terminated.
        /// </summary>
        [EnumMember(Value = "terminate")]
        Terminate,
        /// <summary>
        /// Allow currently running Tasks to complete. Schedule no new Tasks
        /// while waiting. Deallocate the Compute Node when all Tasks have
        /// completed.
        /// </summary>
        [EnumMember(Value = "taskcompletion")]
        TaskCompletion,
        /// <summary>
        /// Allow currently running Tasks to complete, then wait for all Task
        /// data retention periods to expire. Schedule no new Tasks while
        /// waiting. Deallocate the Compute Node when all Task retention
        /// periods have expired.
        /// </summary>
        [EnumMember(Value = "retaineddata")]
        RetainedData
    }
    internal static class ComputeNodeDeallocateOptionEnumExtension
    {
        internal static string ToSerializedValue(this ComputeNodeDeallocateOption? value)
        {
            return value == null ? null : ((ComputeNodeDeallocateOption)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this ComputeNodeDeallocateOption value)
        {
            switch( value )
            {
                case ComputeNodeDeallocateOption.Requeue:
                    return "requeue";
                case ComputeNodeDeallocateOption.Terminate:
                    return "terminate";
                case ComputeNodeDeallocateOption.TaskCompletion:
                    return "taskcompletion";
                case ComputeNodeDeallocateOption.RetainedData:
                    return "retaineddata";
            }
            return null;
        }

        internal static ComputeNodeDeallocateOption? ParseComputeNodeDeallocateOption(this string value)
        {
            switch( value )
            {
                case "requeue":
                    return ComputeNodeDeallocateOption.Requeue;
                case "terminate":
                    return ComputeNodeDeallocateOption.Terminate;
                case "taskcompletion":
                    return ComputeNodeDeallocateOption.TaskCompletion;
                case "retaineddata":
                    return ComputeNodeDeallocateOption.RetainedData;
            }
            return null;
        }
    }
}
