// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An Azure Batch Task.
    /// </summary>
    /// <remarks>
    /// Batch will retry Tasks when a recovery operation is triggered on a
    /// Node. Examples of recovery operations include (but are not limited to)
    /// when an unhealthy Node is rebooted or a Compute Node disappeared due to
    /// host failure. Retries due to recovery operations are independent of and
    /// are not counted against the maxTaskRetryCount. Even if the
    /// maxTaskRetryCount is 0, an internal retry due to a recovery operation
    /// may occur. Because of this, all Tasks should be idempotent. This means
    /// Tasks need to tolerate being interrupted and restarted without causing
    /// any corruption or duplicate data. The best practice for long running
    /// Tasks is to use some form of checkpointing.
    /// </remarks>
    public partial class CloudTask
    {
        /// <summary>
        /// Initializes a new instance of the CloudTask class.
        /// </summary>
        public CloudTask()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the CloudTask class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the Task within
        /// the Job.</param>
        /// <param name="displayName">A display name for the Task.</param>
        /// <param name="url">The URL of the Task.</param>
        /// <param name="eTag">The ETag of the Task.</param>
        /// <param name="lastModified">The last modified time of the
        /// Task.</param>
        /// <param name="creationTime">The creation time of the Task.</param>
        /// <param name="exitConditions">How the Batch service should respond
        /// when the Task completes.</param>
        /// <param name="state">The current state of the Task.</param>
        /// <param name="stateTransitionTime">The time at which the Task
        /// entered its current state.</param>
        /// <param name="previousState">The previous state of the Task.</param>
        /// <param name="previousStateTransitionTime">The time at which the
        /// Task entered its previous state.</param>
        /// <param name="commandLine">The command line of the Task.</param>
        /// <param name="containerSettings">The settings for the container
        /// under which the Task runs.</param>
        /// <param name="resourceFiles">A list of files that the Batch service
        /// will download to the Compute Node before running the command
        /// line.</param>
        /// <param name="outputFiles">A list of files that the Batch service
        /// will upload from the Compute Node after running the command
        /// line.</param>
        /// <param name="environmentSettings">A list of environment variable
        /// settings for the Task.</param>
        /// <param name="affinityInfo">A locality hint that can be used by the
        /// Batch service to select a Compute Node on which to start the new
        /// Task.</param>
        /// <param name="constraints">The execution constraints that apply to
        /// this Task.</param>
        /// <param name="requiredSlots">The number of scheduling slots that the
        /// Task requires to run.</param>
        /// <param name="userIdentity">The user identity under which the Task
        /// runs.</param>
        /// <param name="executionInfo">Information about the execution of the
        /// Task.</param>
        /// <param name="nodeInfo">Information about the Compute Node on which
        /// the Task ran.</param>
        /// <param name="multiInstanceSettings">An object that indicates that
        /// the Task is a multi-instance Task, and contains information about
        /// how to run the multi-instance Task.</param>
        /// <param name="stats">Resource usage statistics for the Task.</param>
        /// <param name="dependsOn">The Tasks that this Task depends
        /// on.</param>
        /// <param name="applicationPackageReferences">A list of Packages that
        /// the Batch service will deploy to the Compute Node before running
        /// the command line.</param>
        /// <param name="authenticationTokenSettings">The settings for an
        /// authentication token that the Task can use to perform Batch service
        /// operations.</param>
        public CloudTask(string id = default(string), string displayName = default(string), string url = default(string), string eTag = default(string), System.DateTime? lastModified = default(System.DateTime?), System.DateTime? creationTime = default(System.DateTime?), ExitConditions exitConditions = default(ExitConditions), TaskState? state = default(TaskState?), System.DateTime? stateTransitionTime = default(System.DateTime?), TaskState? previousState = default(TaskState?), System.DateTime? previousStateTransitionTime = default(System.DateTime?), string commandLine = default(string), TaskContainerSettings containerSettings = default(TaskContainerSettings), IList<ResourceFile> resourceFiles = default(IList<ResourceFile>), IList<OutputFile> outputFiles = default(IList<OutputFile>), IList<EnvironmentSetting> environmentSettings = default(IList<EnvironmentSetting>), AffinityInformation affinityInfo = default(AffinityInformation), TaskConstraints constraints = default(TaskConstraints), int? requiredSlots = default(int?), UserIdentity userIdentity = default(UserIdentity), TaskExecutionInformation executionInfo = default(TaskExecutionInformation), ComputeNodeInformation nodeInfo = default(ComputeNodeInformation), MultiInstanceSettings multiInstanceSettings = default(MultiInstanceSettings), TaskStatistics stats = default(TaskStatistics), TaskDependencies dependsOn = default(TaskDependencies), IList<ApplicationPackageReference> applicationPackageReferences = default(IList<ApplicationPackageReference>), AuthenticationTokenSettings authenticationTokenSettings = default(AuthenticationTokenSettings))
        {
            Id = id;
            DisplayName = displayName;
            Url = url;
            ETag = eTag;
            LastModified = lastModified;
            CreationTime = creationTime;
            ExitConditions = exitConditions;
            State = state;
            StateTransitionTime = stateTransitionTime;
            PreviousState = previousState;
            PreviousStateTransitionTime = previousStateTransitionTime;
            CommandLine = commandLine;
            ContainerSettings = containerSettings;
            ResourceFiles = resourceFiles;
            OutputFiles = outputFiles;
            EnvironmentSettings = environmentSettings;
            AffinityInfo = affinityInfo;
            Constraints = constraints;
            RequiredSlots = requiredSlots;
            UserIdentity = userIdentity;
            ExecutionInfo = executionInfo;
            NodeInfo = nodeInfo;
            MultiInstanceSettings = multiInstanceSettings;
            Stats = stats;
            DependsOn = dependsOn;
            ApplicationPackageReferences = applicationPackageReferences;
            AuthenticationTokenSettings = authenticationTokenSettings;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the Task within the
        /// Job.
        /// </summary>
        /// <remarks>
        /// The ID can contain any combination of alphanumeric characters
        /// including hyphens and underscores, and cannot contain more than 64
        /// characters.
        /// </remarks>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a display name for the Task.
        /// </summary>
        /// <remarks>
        /// The display name need not be unique and can contain any Unicode
        /// characters up to a maximum length of 1024.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the URL of the Task.
        /// </summary>
        [JsonProperty(PropertyName = "url")]
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the ETag of the Task.
        /// </summary>
        /// <remarks>
        /// This is an opaque string. You can use it to detect whether the Task
        /// has changed between requests. In particular, you can be pass the
        /// ETag when updating a Task to specify that your changes should take
        /// effect only if nobody else has modified the Task in the meantime.
        /// </remarks>
        [JsonProperty(PropertyName = "eTag")]
        public string ETag { get; set; }

        /// <summary>
        /// Gets or sets the last modified time of the Task.
        /// </summary>
        [JsonProperty(PropertyName = "lastModified")]
        public System.DateTime? LastModified { get; set; }

        /// <summary>
        /// Gets or sets the creation time of the Task.
        /// </summary>
        [JsonProperty(PropertyName = "creationTime")]
        public System.DateTime? CreationTime { get; set; }

        /// <summary>
        /// Gets or sets how the Batch service should respond when the Task
        /// completes.
        /// </summary>
        [JsonProperty(PropertyName = "exitConditions")]
        public ExitConditions ExitConditions { get; set; }

        /// <summary>
        /// Gets or sets the current state of the Task.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'active', 'preparing', 'running',
        /// 'completed'
        /// </remarks>
        [JsonProperty(PropertyName = "state")]
        public TaskState? State { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Task entered its current state.
        /// </summary>
        [JsonProperty(PropertyName = "stateTransitionTime")]
        public System.DateTime? StateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets the previous state of the Task.
        /// </summary>
        /// <remarks>
        /// This property is not set if the Task is in its initial Active
        /// state. Possible values include: 'active', 'preparing', 'running',
        /// 'completed'
        /// </remarks>
        [JsonProperty(PropertyName = "previousState")]
        public TaskState? PreviousState { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Task entered its previous state.
        /// </summary>
        /// <remarks>
        /// This property is not set if the Task is in its initial Active
        /// state.
        /// </remarks>
        [JsonProperty(PropertyName = "previousStateTransitionTime")]
        public System.DateTime? PreviousStateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets the command line of the Task.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the command line is executed as the
        /// primary Task, after the primary Task and all subtasks have finished
        /// executing the coordination command line. The command line does not
        /// run under a shell, and therefore cannot take advantage of shell
        /// features such as environment variable expansion. If you want to
        /// take advantage of such features, you should invoke the shell in the
        /// command line, for example using "cmd /c MyCommand" in Windows or
        /// "/bin/sh -c MyCommand" in Linux. If the command line refers to file
        /// paths, it should use a relative path (relative to the Task working
        /// directory), or use the Batch provided environment variable
        /// (https://docs.microsoft.com/azure/batch/batch-compute-node-environment-variables).
        /// </remarks>
        [JsonProperty(PropertyName = "commandLine")]
        public string CommandLine { get; set; }

        /// <summary>
        /// Gets or sets the settings for the container under which the Task
        /// runs.
        /// </summary>
        /// <remarks>
        /// If the Pool that will run this Task has containerConfiguration set,
        /// this must be set as well. If the Pool that will run this Task
        /// doesn't have containerConfiguration set, this must not be set. When
        /// this is specified, all directories recursively below the
        /// AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
        /// node) are mapped into the container, all Task environment variables
        /// are mapped into the container, and the Task command line is
        /// executed in the container. Files produced in the container outside
        /// of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk,
        /// meaning that Batch file APIs will not be able to access those
        /// files.
        /// </remarks>
        [JsonProperty(PropertyName = "containerSettings")]
        public TaskContainerSettings ContainerSettings { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will download
        /// to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the resource files will only be
        /// downloaded to the Compute Node on which the primary Task is
        /// executed. There is a maximum size for the list of resource files.
        /// When the max size is exceeded, the request will fail and the
        /// response error code will be RequestEntityTooLarge. If this occurs,
        /// the collection of ResourceFiles must be reduced in size. This can
        /// be achieved using .zip files, Application Packages, or Docker
        /// Containers.
        /// </remarks>
        [JsonProperty(PropertyName = "resourceFiles")]
        public IList<ResourceFile> ResourceFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of files that the Batch service will upload
        /// from the Compute Node after running the command line.
        /// </summary>
        /// <remarks>
        /// For multi-instance Tasks, the files will only be uploaded from the
        /// Compute Node on which the primary Task is executed.
        /// </remarks>
        [JsonProperty(PropertyName = "outputFiles")]
        public IList<OutputFile> OutputFiles { get; set; }

        /// <summary>
        /// Gets or sets a list of environment variable settings for the Task.
        /// </summary>
        [JsonProperty(PropertyName = "environmentSettings")]
        public IList<EnvironmentSetting> EnvironmentSettings { get; set; }

        /// <summary>
        /// Gets or sets a locality hint that can be used by the Batch service
        /// to select a Compute Node on which to start the new Task.
        /// </summary>
        [JsonProperty(PropertyName = "affinityInfo")]
        public AffinityInformation AffinityInfo { get; set; }

        /// <summary>
        /// Gets or sets the execution constraints that apply to this Task.
        /// </summary>
        [JsonProperty(PropertyName = "constraints")]
        public TaskConstraints Constraints { get; set; }

        /// <summary>
        /// Gets or sets the number of scheduling slots that the Task requires
        /// to run.
        /// </summary>
        /// <remarks>
        /// The default is 1. A Task can only be scheduled to run on a compute
        /// node if the node has enough free scheduling slots available. For
        /// multi-instance Tasks, this must be 1.
        /// </remarks>
        [JsonProperty(PropertyName = "requiredSlots")]
        public int? RequiredSlots { get; set; }

        /// <summary>
        /// Gets or sets the user identity under which the Task runs.
        /// </summary>
        /// <remarks>
        /// If omitted, the Task runs as a non-administrative user unique to
        /// the Task.
        /// </remarks>
        [JsonProperty(PropertyName = "userIdentity")]
        public UserIdentity UserIdentity { get; set; }

        /// <summary>
        /// Gets or sets information about the execution of the Task.
        /// </summary>
        [JsonProperty(PropertyName = "executionInfo")]
        public TaskExecutionInformation ExecutionInfo { get; set; }

        /// <summary>
        /// Gets or sets information about the Compute Node on which the Task
        /// ran.
        /// </summary>
        [JsonProperty(PropertyName = "nodeInfo")]
        public ComputeNodeInformation NodeInfo { get; set; }

        /// <summary>
        /// Gets or sets an object that indicates that the Task is a
        /// multi-instance Task, and contains information about how to run the
        /// multi-instance Task.
        /// </summary>
        [JsonProperty(PropertyName = "multiInstanceSettings")]
        public MultiInstanceSettings MultiInstanceSettings { get; set; }

        /// <summary>
        /// Gets or sets resource usage statistics for the Task.
        /// </summary>
        [JsonProperty(PropertyName = "stats")]
        public TaskStatistics Stats { get; set; }

        /// <summary>
        /// Gets or sets the Tasks that this Task depends on.
        /// </summary>
        /// <remarks>
        /// This Task will not be scheduled until all Tasks that it depends on
        /// have completed successfully. If any of those Tasks fail and exhaust
        /// their retry counts, this Task will never be scheduled.
        /// </remarks>
        [JsonProperty(PropertyName = "dependsOn")]
        public TaskDependencies DependsOn { get; set; }

        /// <summary>
        /// Gets or sets a list of Packages that the Batch service will deploy
        /// to the Compute Node before running the command line.
        /// </summary>
        /// <remarks>
        /// Application packages are downloaded and deployed to a shared
        /// directory, not the Task working directory. Therefore, if a
        /// referenced package is already on the Node, and is up to date, then
        /// it is not re-downloaded; the existing copy on the Compute Node is
        /// used. If a referenced Package cannot be installed, for example
        /// because the package has been deleted or because download failed,
        /// the Task fails.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets the settings for an authentication token that the Task
        /// can use to perform Batch service operations.
        /// </summary>
        /// <remarks>
        /// If this property is set, the Batch service provides the Task with
        /// an authentication token which can be used to authenticate Batch
        /// service operations without requiring an Account access key. The
        /// token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment
        /// variable. The operations that the Task can carry out using the
        /// token depend on the settings. For example, a Task can request Job
        /// permissions in order to add other Tasks to the Job, or check the
        /// status of the Job or of other Tasks under the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "authenticationTokenSettings")]
        public AuthenticationTokenSettings AuthenticationTokenSettings { get; set; }

    }
}
