// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A Pool in the Azure Batch service.
    /// </summary>
    public partial class CloudPool
    {
        /// <summary>
        /// Initializes a new instance of the CloudPool class.
        /// </summary>
        public CloudPool()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the CloudPool class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the Pool within
        /// the Account.</param>
        /// <param name="displayName">The display name for the Pool.</param>
        /// <param name="url">The URL of the Pool.</param>
        /// <param name="eTag">The ETag of the Pool.</param>
        /// <param name="lastModified">The last modified time of the
        /// Pool.</param>
        /// <param name="creationTime">The creation time of the Pool.</param>
        /// <param name="state">The current state of the Pool.</param>
        /// <param name="stateTransitionTime">The time at which the Pool
        /// entered its current state.</param>
        /// <param name="allocationState">Whether the Pool is resizing.</param>
        /// <param name="allocationStateTransitionTime">The time at which the
        /// Pool entered its current allocation state.</param>
        /// <param name="vmSize">The size of virtual machines in the Pool. All
        /// virtual machines in a Pool are the same size.</param>
        /// <param name="virtualMachineConfiguration">The virtual machine
        /// configuration for the Pool.</param>
        /// <param name="resizeTimeout">The timeout for allocation of Compute
        /// Nodes to the Pool.</param>
        /// <param name="resizeErrors">A list of errors encountered while
        /// performing the last resize on the Pool.</param>
        /// <param name="currentDedicatedNodes">The number of dedicated Compute
        /// Nodes currently in the Pool.</param>
        /// <param name="currentLowPriorityNodes">The number of
        /// Spot/Low-priority Compute Nodes currently in the Pool.</param>
        /// <param name="targetDedicatedNodes">The desired number of dedicated
        /// Compute Nodes in the Pool.</param>
        /// <param name="targetLowPriorityNodes">The desired number of
        /// Spot/Low-priority Compute Nodes in the Pool.</param>
        /// <param name="enableAutoScale">Whether the Pool size should
        /// automatically adjust over time.</param>
        /// <param name="autoScaleFormula">A formula for the desired number of
        /// Compute Nodes in the Pool.</param>
        /// <param name="autoScaleEvaluationInterval">The time interval at
        /// which to automatically adjust the Pool size according to the
        /// autoscale formula.</param>
        /// <param name="autoScaleRun">The results and errors from the last
        /// execution of the autoscale formula.</param>
        /// <param name="enableInterNodeCommunication">Whether the Pool permits
        /// direct communication between Compute Nodes.</param>
        /// <param name="networkConfiguration">The network configuration for
        /// the Pool.</param>
        /// <param name="startTask">A Task specified to run on each Compute
        /// Node as it joins the Pool.</param>
        /// <param name="certificateReferences">The list of Certificates to be
        /// installed on each Compute Node in the Pool.</param>
        /// <param name="applicationPackageReferences">The list of Packages to
        /// be installed on each Compute Node in the Pool.</param>
        /// <param name="taskSlotsPerNode">The number of task slots that can be
        /// used to run concurrent tasks on a single compute node in the
        /// pool.</param>
        /// <param name="taskSchedulingPolicy">How Tasks are distributed across
        /// Compute Nodes in a Pool.</param>
        /// <param name="userAccounts">The list of user Accounts to be created
        /// on each Compute Node in the Pool.</param>
        /// <param name="metadata">A list of name-value pairs associated with
        /// the Pool as metadata.</param>
        /// <param name="stats">Utilization and resource usage statistics for
        /// the entire lifetime of the Pool.</param>
        /// <param name="mountConfiguration">A list of file systems to mount on
        /// each node in the pool.</param>
        /// <param name="identity">The identity of the Batch pool, if
        /// configured.</param>
        /// <param name="targetNodeCommunicationMode">The desired node
        /// communication mode for the pool.</param>
        /// <param name="currentNodeCommunicationMode">The current state of the
        /// pool communication mode.</param>
        /// <param name="upgradePolicy">The upgrade policy for the
        /// Pool.</param>
        /// <param name="resourceTags">The user-specified tags associated with
        /// the pool.</param>
        public CloudPool(string id = default(string), string displayName = default(string), string url = default(string), string eTag = default(string), System.DateTime? lastModified = default(System.DateTime?), System.DateTime? creationTime = default(System.DateTime?), PoolState? state = default(PoolState?), System.DateTime? stateTransitionTime = default(System.DateTime?), AllocationState? allocationState = default(AllocationState?), System.DateTime? allocationStateTransitionTime = default(System.DateTime?), string vmSize = default(string), VirtualMachineConfiguration virtualMachineConfiguration = default(VirtualMachineConfiguration), System.TimeSpan? resizeTimeout = default(System.TimeSpan?), IList<ResizeError> resizeErrors = default(IList<ResizeError>), int? currentDedicatedNodes = default(int?), int? currentLowPriorityNodes = default(int?), int? targetDedicatedNodes = default(int?), int? targetLowPriorityNodes = default(int?), bool? enableAutoScale = default(bool?), string autoScaleFormula = default(string), System.TimeSpan? autoScaleEvaluationInterval = default(System.TimeSpan?), AutoScaleRun autoScaleRun = default(AutoScaleRun), bool? enableInterNodeCommunication = default(bool?), NetworkConfiguration networkConfiguration = default(NetworkConfiguration), StartTask startTask = default(StartTask), IList<CertificateReference> certificateReferences = default(IList<CertificateReference>), IList<ApplicationPackageReference> applicationPackageReferences = default(IList<ApplicationPackageReference>), int? taskSlotsPerNode = default(int?), TaskSchedulingPolicy taskSchedulingPolicy = default(TaskSchedulingPolicy), IList<UserAccount> userAccounts = default(IList<UserAccount>), IList<MetadataItem> metadata = default(IList<MetadataItem>), PoolStatistics stats = default(PoolStatistics), IList<MountConfiguration> mountConfiguration = default(IList<MountConfiguration>), BatchPoolIdentity identity = default(BatchPoolIdentity), NodeCommunicationMode? targetNodeCommunicationMode = default(NodeCommunicationMode?), NodeCommunicationMode? currentNodeCommunicationMode = default(NodeCommunicationMode?), UpgradePolicy upgradePolicy = default(UpgradePolicy), IDictionary<string, string> resourceTags = default(IDictionary<string, string>))
        {
            Id = id;
            DisplayName = displayName;
            Url = url;
            ETag = eTag;
            LastModified = lastModified;
            CreationTime = creationTime;
            State = state;
            StateTransitionTime = stateTransitionTime;
            AllocationState = allocationState;
            AllocationStateTransitionTime = allocationStateTransitionTime;
            VmSize = vmSize;
            VirtualMachineConfiguration = virtualMachineConfiguration;
            ResizeTimeout = resizeTimeout;
            ResizeErrors = resizeErrors;
            CurrentDedicatedNodes = currentDedicatedNodes;
            CurrentLowPriorityNodes = currentLowPriorityNodes;
            TargetDedicatedNodes = targetDedicatedNodes;
            TargetLowPriorityNodes = targetLowPriorityNodes;
            EnableAutoScale = enableAutoScale;
            AutoScaleFormula = autoScaleFormula;
            AutoScaleEvaluationInterval = autoScaleEvaluationInterval;
            AutoScaleRun = autoScaleRun;
            EnableInterNodeCommunication = enableInterNodeCommunication;
            NetworkConfiguration = networkConfiguration;
            StartTask = startTask;
            CertificateReferences = certificateReferences;
            ApplicationPackageReferences = applicationPackageReferences;
            TaskSlotsPerNode = taskSlotsPerNode;
            TaskSchedulingPolicy = taskSchedulingPolicy;
            UserAccounts = userAccounts;
            Metadata = metadata;
            Stats = stats;
            MountConfiguration = mountConfiguration;
            Identity = identity;
            TargetNodeCommunicationMode = targetNodeCommunicationMode;
            CurrentNodeCommunicationMode = currentNodeCommunicationMode;
            UpgradePolicy = upgradePolicy;
            ResourceTags = resourceTags;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the Pool within the
        /// Account.
        /// </summary>
        /// <remarks>
        /// The ID can contain any combination of alphanumeric characters
        /// including hyphens and underscores, and cannot contain more than 64
        /// characters. The ID is case-preserving and case-insensitive (that
        /// is, you may not have two IDs within an Account that differ only by
        /// case).
        /// </remarks>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the display name for the Pool.
        /// </summary>
        /// <remarks>
        /// The display name need not be unique and can contain any Unicode
        /// characters up to a maximum length of 1024.
        /// </remarks>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the URL of the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "url")]
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the ETag of the Pool.
        /// </summary>
        /// <remarks>
        /// This is an opaque string. You can use it to detect whether the Pool
        /// has changed between requests. In particular, you can be pass the
        /// ETag when updating a Pool to specify that your changes should take
        /// effect only if nobody else has modified the Pool in the meantime.
        /// </remarks>
        [JsonProperty(PropertyName = "eTag")]
        public string ETag { get; set; }

        /// <summary>
        /// Gets or sets the last modified time of the Pool.
        /// </summary>
        /// <remarks>
        /// This is the last time at which the Pool level data, such as the
        /// targetDedicatedNodes or enableAutoscale settings, changed. It does
        /// not factor in node-level changes such as a Compute Node changing
        /// state.
        /// </remarks>
        [JsonProperty(PropertyName = "lastModified")]
        public System.DateTime? LastModified { get; set; }

        /// <summary>
        /// Gets or sets the creation time of the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "creationTime")]
        public System.DateTime? CreationTime { get; set; }

        /// <summary>
        /// Gets or sets the current state of the Pool.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'active', 'deleting'
        /// </remarks>
        [JsonProperty(PropertyName = "state")]
        public PoolState? State { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Pool entered its current state.
        /// </summary>
        [JsonProperty(PropertyName = "stateTransitionTime")]
        public System.DateTime? StateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets whether the Pool is resizing.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'steady', 'resizing', 'stopping'
        /// </remarks>
        [JsonProperty(PropertyName = "allocationState")]
        public AllocationState? AllocationState { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Pool entered its current
        /// allocation state.
        /// </summary>
        [JsonProperty(PropertyName = "allocationStateTransitionTime")]
        public System.DateTime? AllocationStateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets the size of virtual machines in the Pool. All virtual
        /// machines in a Pool are the same size.
        /// </summary>
        /// <remarks>
        /// For information about available sizes of virtual machines in Pools,
        /// see Choose a VM size for Compute Nodes in an Azure Batch Pool
        /// (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
        /// </remarks>
        [JsonProperty(PropertyName = "vmSize")]
        public string VmSize { get; set; }

        /// <summary>
        /// Gets or sets the virtual machine configuration for the Pool.
        /// </summary>
        /// <remarks>
        /// This property must be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "virtualMachineConfiguration")]
        public VirtualMachineConfiguration VirtualMachineConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the timeout for allocation of Compute Nodes to the
        /// Pool.
        /// </summary>
        /// <remarks>
        /// This is the timeout for the most recent resize operation. (The
        /// initial sizing when the Pool is created counts as a resize.) The
        /// default value is 15 minutes.
        /// </remarks>
        [JsonProperty(PropertyName = "resizeTimeout")]
        public System.TimeSpan? ResizeTimeout { get; set; }

        /// <summary>
        /// Gets or sets a list of errors encountered while performing the last
        /// resize on the Pool.
        /// </summary>
        /// <remarks>
        /// This property is set only if one or more errors occurred during the
        /// last Pool resize, and only when the Pool allocationState is Steady.
        /// </remarks>
        [JsonProperty(PropertyName = "resizeErrors")]
        public IList<ResizeError> ResizeErrors { get; set; }

        /// <summary>
        /// Gets or sets the number of dedicated Compute Nodes currently in the
        /// Pool.
        /// </summary>
        [JsonProperty(PropertyName = "currentDedicatedNodes")]
        public int? CurrentDedicatedNodes { get; set; }

        /// <summary>
        /// Gets or sets the number of Spot/Low-priority Compute Nodes
        /// currently in the Pool.
        /// </summary>
        /// <remarks>
        /// Spot/Low-priority Compute Nodes which have been preempted are
        /// included in this count.
        /// </remarks>
        [JsonProperty(PropertyName = "currentLowPriorityNodes")]
        public int? CurrentLowPriorityNodes { get; set; }

        /// <summary>
        /// Gets or sets the desired number of dedicated Compute Nodes in the
        /// Pool.
        /// </summary>
        [JsonProperty(PropertyName = "targetDedicatedNodes")]
        public int? TargetDedicatedNodes { get; set; }

        /// <summary>
        /// Gets or sets the desired number of Spot/Low-priority Compute Nodes
        /// in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "targetLowPriorityNodes")]
        public int? TargetLowPriorityNodes { get; set; }

        /// <summary>
        /// Gets or sets whether the Pool size should automatically adjust over
        /// time.
        /// </summary>
        /// <remarks>
        /// If false, at least one of targetDedicatedNodes and
        /// targetLowPriorityNodes must be specified. If true, the
        /// autoScaleFormula property is required and the Pool automatically
        /// resizes according to the formula. The default value is false.
        /// </remarks>
        [JsonProperty(PropertyName = "enableAutoScale")]
        public bool? EnableAutoScale { get; set; }

        /// <summary>
        /// Gets or sets a formula for the desired number of Compute Nodes in
        /// the Pool.
        /// </summary>
        /// <remarks>
        /// This property is set only if the Pool automatically scales, i.e.
        /// enableAutoScale is true.
        /// </remarks>
        [JsonProperty(PropertyName = "autoScaleFormula")]
        public string AutoScaleFormula { get; set; }

        /// <summary>
        /// Gets or sets the time interval at which to automatically adjust the
        /// Pool size according to the autoscale formula.
        /// </summary>
        /// <remarks>
        /// This property is set only if the Pool automatically scales, i.e.
        /// enableAutoScale is true.
        /// </remarks>
        [JsonProperty(PropertyName = "autoScaleEvaluationInterval")]
        public System.TimeSpan? AutoScaleEvaluationInterval { get; set; }

        /// <summary>
        /// Gets or sets the results and errors from the last execution of the
        /// autoscale formula.
        /// </summary>
        /// <remarks>
        /// This property is set only if the Pool automatically scales, i.e.
        /// enableAutoScale is true.
        /// </remarks>
        [JsonProperty(PropertyName = "autoScaleRun")]
        public AutoScaleRun AutoScaleRun { get; set; }

        /// <summary>
        /// Gets or sets whether the Pool permits direct communication between
        /// Compute Nodes.
        /// </summary>
        /// <remarks>
        /// This imposes restrictions on which Compute Nodes can be assigned to
        /// the Pool. Specifying this value can reduce the chance of the
        /// requested number of Compute Nodes to be allocated in the Pool.
        /// </remarks>
        [JsonProperty(PropertyName = "enableInterNodeCommunication")]
        public bool? EnableInterNodeCommunication { get; set; }

        /// <summary>
        /// Gets or sets the network configuration for the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "networkConfiguration")]
        public NetworkConfiguration NetworkConfiguration { get; set; }

        /// <summary>
        /// Gets or sets a Task specified to run on each Compute Node as it
        /// joins the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "startTask")]
        public StartTask StartTask { get; set; }

        /// <summary>
        /// Gets or sets the list of Certificates to be installed on each
        /// Compute Node in the Pool.
        /// </summary>
        /// <remarks>
        /// For Windows Nodes, the Batch service installs the Certificates to
        /// the specified Certificate store and location. For Linux Compute
        /// Nodes, the Certificates are stored in a directory inside the Task
        /// working directory and an environment variable
        /// AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this
        /// location. For Certificates with visibility of 'remoteUser', a
        /// 'certs' directory is created in the user's home directory (e.g.,
        /// /home/{user-name}/certs) and Certificates are placed in that
        /// directory.
        ///
        /// Warning: This property is deprecated and will be removed after
        /// February, 2024. Please use the [Azure KeyVault
        /// Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide)
        /// instead.
        /// </remarks>
        [JsonProperty(PropertyName = "certificateReferences")]
        public IList<CertificateReference> CertificateReferences { get; set; }

        /// <summary>
        /// Gets or sets the list of Packages to be installed on each Compute
        /// Node in the Pool.
        /// </summary>
        /// <remarks>
        /// Changes to Package references affect all new Nodes joining the
        /// Pool, but do not affect Compute Nodes that are already in the Pool
        /// until they are rebooted or reimaged. There is a maximum of 10
        /// Package references on any given Pool.
        /// </remarks>
        [JsonProperty(PropertyName = "applicationPackageReferences")]
        public IList<ApplicationPackageReference> ApplicationPackageReferences { get; set; }

        /// <summary>
        /// Gets or sets the number of task slots that can be used to run
        /// concurrent tasks on a single compute node in the pool.
        /// </summary>
        /// <remarks>
        /// The default value is 1. The maximum value is the smaller of 4 times
        /// the number of cores of the vmSize of the pool or 256.
        /// </remarks>
        [JsonProperty(PropertyName = "taskSlotsPerNode")]
        public int? TaskSlotsPerNode { get; set; }

        /// <summary>
        /// Gets or sets how Tasks are distributed across Compute Nodes in a
        /// Pool.
        /// </summary>
        /// <remarks>
        /// If not specified, the default is spread.
        /// </remarks>
        [JsonProperty(PropertyName = "taskSchedulingPolicy")]
        public TaskSchedulingPolicy TaskSchedulingPolicy { get; set; }

        /// <summary>
        /// Gets or sets the list of user Accounts to be created on each
        /// Compute Node in the Pool.
        /// </summary>
        [JsonProperty(PropertyName = "userAccounts")]
        public IList<UserAccount> UserAccounts { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with the Pool as
        /// metadata.
        /// </summary>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataItem> Metadata { get; set; }

        /// <summary>
        /// Gets or sets utilization and resource usage statistics for the
        /// entire lifetime of the Pool.
        /// </summary>
        /// <remarks>
        /// This property is populated only if the CloudPool was retrieved with
        /// an expand clause including the 'stats' attribute; otherwise it is
        /// null. The statistics may not be immediately available. The Batch
        /// service performs periodic roll-up of statistics. The typical delay
        /// is about 30 minutes.
        /// </remarks>
        [JsonProperty(PropertyName = "stats")]
        public PoolStatistics Stats { get; set; }

        /// <summary>
        /// Gets or sets a list of file systems to mount on each node in the
        /// pool.
        /// </summary>
        /// <remarks>
        /// This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
        /// </remarks>
        [JsonProperty(PropertyName = "mountConfiguration")]
        public IList<MountConfiguration> MountConfiguration { get; set; }

        /// <summary>
        /// Gets or sets the identity of the Batch pool, if configured.
        /// </summary>
        /// <remarks>
        /// The list of user identities associated with the Batch pool. The
        /// user identity dictionary key references will be ARM resource ids in
        /// the form:
        /// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// </remarks>
        [JsonProperty(PropertyName = "identity")]
        public BatchPoolIdentity Identity { get; set; }

        /// <summary>
        /// Gets or sets the desired node communication mode for the pool.
        /// </summary>
        /// <remarks>
        /// If omitted, the default value is Default. Possible values include:
        /// 'default', 'classic', 'simplified'
        /// </remarks>
        [JsonProperty(PropertyName = "targetNodeCommunicationMode")]
        public NodeCommunicationMode? TargetNodeCommunicationMode { get; set; }

        /// <summary>
        /// Gets the current state of the pool communication mode.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'default', 'classic', 'simplified'
        /// </remarks>
        [JsonProperty(PropertyName = "currentNodeCommunicationMode")]
        public NodeCommunicationMode? CurrentNodeCommunicationMode { get; private set; }

        /// <summary>
        /// Gets or sets the upgrade policy for the Pool.
        /// </summary>
        /// <remarks>
        /// Describes an upgrade policy - automatic, manual, or rolling.
        /// </remarks>
        [JsonProperty(PropertyName = "upgradePolicy")]
        public UpgradePolicy UpgradePolicy { get; set; }

        /// <summary>
        /// Gets or sets the user-specified tags associated with the pool.
        /// </summary>
        /// <remarks>
        /// The user-defined tags to be associated with the Azure Batch Pool.
        /// When specified, these tags are propagated to the backing Azure
        /// resources associated with the pool. This property can only be
        /// specified when the Batch account was created with the
        /// poolAllocationMode property set to 'UserSubscription'.
        /// </remarks>
        [JsonProperty(PropertyName = "resourceTags")]
        public IDictionary<string, string> ResourceTags { get; set; }

    }
}
