// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An Azure Batch Job.
    /// </summary>
    public partial class CloudJob
    {
        /// <summary>
        /// Initializes a new instance of the CloudJob class.
        /// </summary>
        public CloudJob()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the CloudJob class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the Job within
        /// the Account.</param>
        /// <param name="displayName">The display name for the Job.</param>
        /// <param name="usesTaskDependencies">Whether Tasks in the Job can
        /// define dependencies on each other. The default is false.</param>
        /// <param name="url">The URL of the Job.</param>
        /// <param name="eTag">The ETag of the Job.</param>
        /// <param name="lastModified">The last modified time of the
        /// Job.</param>
        /// <param name="creationTime">The creation time of the Job.</param>
        /// <param name="state">The current state of the Job.</param>
        /// <param name="stateTransitionTime">The time at which the Job entered
        /// its current state.</param>
        /// <param name="previousState">The previous state of the Job.</param>
        /// <param name="previousStateTransitionTime">The time at which the Job
        /// entered its previous state.</param>
        /// <param name="priority">The priority of the Job.</param>
        /// <param name="allowTaskPreemption">Whether Tasks in this job can be
        /// preempted by other high priority jobs</param>
        /// <param name="maxParallelTasks">The maximum number of tasks that can
        /// be executed in parallel for the job.</param>
        /// <param name="constraints">The execution constraints for the
        /// Job.</param>
        /// <param name="jobManagerTask">Details of a Job Manager Task to be
        /// launched when the Job is started.</param>
        /// <param name="jobPreparationTask">The Job Preparation Task.</param>
        /// <param name="jobReleaseTask">The Job Release Task.</param>
        /// <param name="commonEnvironmentSettings">The list of common
        /// environment variable settings. These environment variables are set
        /// for all Tasks in the Job (including the Job Manager, Job
        /// Preparation and Job Release Tasks).</param>
        /// <param name="poolInfo">The Pool settings associated with the
        /// Job.</param>
        /// <param name="onAllTasksComplete">The action the Batch service
        /// should take when all Tasks in the Job are in the completed
        /// state.</param>
        /// <param name="onTaskFailure">The action the Batch service should
        /// take when any Task in the Job fails.</param>
        /// <param name="networkConfiguration">The network configuration for
        /// the Job.</param>
        /// <param name="metadata">A list of name-value pairs associated with
        /// the Job as metadata.</param>
        /// <param name="executionInfo">The execution information for the
        /// Job.</param>
        /// <param name="stats">Resource usage statistics for the entire
        /// lifetime of the Job.</param>
        public CloudJob(string id = default(string), string displayName = default(string), bool? usesTaskDependencies = default(bool?), string url = default(string), string eTag = default(string), System.DateTime? lastModified = default(System.DateTime?), System.DateTime? creationTime = default(System.DateTime?), JobState? state = default(JobState?), System.DateTime? stateTransitionTime = default(System.DateTime?), JobState? previousState = default(JobState?), System.DateTime? previousStateTransitionTime = default(System.DateTime?), int? priority = default(int?), bool? allowTaskPreemption = default(bool?), int? maxParallelTasks = default(int?), JobConstraints constraints = default(JobConstraints), JobManagerTask jobManagerTask = default(JobManagerTask), JobPreparationTask jobPreparationTask = default(JobPreparationTask), JobReleaseTask jobReleaseTask = default(JobReleaseTask), IList<EnvironmentSetting> commonEnvironmentSettings = default(IList<EnvironmentSetting>), PoolInformation poolInfo = default(PoolInformation), OnAllTasksComplete? onAllTasksComplete = default(OnAllTasksComplete?), OnTaskFailure? onTaskFailure = default(OnTaskFailure?), JobNetworkConfiguration networkConfiguration = default(JobNetworkConfiguration), IList<MetadataItem> metadata = default(IList<MetadataItem>), JobExecutionInformation executionInfo = default(JobExecutionInformation), JobStatistics stats = default(JobStatistics))
        {
            Id = id;
            DisplayName = displayName;
            UsesTaskDependencies = usesTaskDependencies;
            Url = url;
            ETag = eTag;
            LastModified = lastModified;
            CreationTime = creationTime;
            State = state;
            StateTransitionTime = stateTransitionTime;
            PreviousState = previousState;
            PreviousStateTransitionTime = previousStateTransitionTime;
            Priority = priority;
            AllowTaskPreemption = allowTaskPreemption;
            MaxParallelTasks = maxParallelTasks;
            Constraints = constraints;
            JobManagerTask = jobManagerTask;
            JobPreparationTask = jobPreparationTask;
            JobReleaseTask = jobReleaseTask;
            CommonEnvironmentSettings = commonEnvironmentSettings;
            PoolInfo = poolInfo;
            OnAllTasksComplete = onAllTasksComplete;
            OnTaskFailure = onTaskFailure;
            NetworkConfiguration = networkConfiguration;
            Metadata = metadata;
            ExecutionInfo = executionInfo;
            Stats = stats;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the Job within the
        /// Account.
        /// </summary>
        /// <remarks>
        /// The ID is case-preserving and case-insensitive (that is, you may
        /// not have two IDs within an Account that differ only by case).
        /// </remarks>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the display name for the Job.
        /// </summary>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets whether Tasks in the Job can define dependencies on
        /// each other. The default is false.
        /// </summary>
        [JsonProperty(PropertyName = "usesTaskDependencies")]
        public bool? UsesTaskDependencies { get; set; }

        /// <summary>
        /// Gets or sets the URL of the Job.
        /// </summary>
        [JsonProperty(PropertyName = "url")]
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the ETag of the Job.
        /// </summary>
        /// <remarks>
        /// This is an opaque string. You can use it to detect whether the Job
        /// has changed between requests. In particular, you can be pass the
        /// ETag when updating a Job to specify that your changes should take
        /// effect only if nobody else has modified the Job in the meantime.
        /// </remarks>
        [JsonProperty(PropertyName = "eTag")]
        public string ETag { get; set; }

        /// <summary>
        /// Gets or sets the last modified time of the Job.
        /// </summary>
        /// <remarks>
        /// This is the last time at which the Job level data, such as the Job
        /// state or priority, changed. It does not factor in task-level
        /// changes such as adding new Tasks or Tasks changing state.
        /// </remarks>
        [JsonProperty(PropertyName = "lastModified")]
        public System.DateTime? LastModified { get; set; }

        /// <summary>
        /// Gets or sets the creation time of the Job.
        /// </summary>
        [JsonProperty(PropertyName = "creationTime")]
        public System.DateTime? CreationTime { get; set; }

        /// <summary>
        /// Gets or sets the current state of the Job.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'active', 'disabling', 'disabled',
        /// 'enabling', 'terminating', 'completed', 'deleting'
        /// </remarks>
        [JsonProperty(PropertyName = "state")]
        public JobState? State { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Job entered its current state.
        /// </summary>
        [JsonProperty(PropertyName = "stateTransitionTime")]
        public System.DateTime? StateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets the previous state of the Job.
        /// </summary>
        /// <remarks>
        /// This property is not set if the Job is in its initial Active state.
        /// Possible values include: 'active', 'disabling', 'disabled',
        /// 'enabling', 'terminating', 'completed', 'deleting'
        /// </remarks>
        [JsonProperty(PropertyName = "previousState")]
        public JobState? PreviousState { get; set; }

        /// <summary>
        /// Gets or sets the time at which the Job entered its previous state.
        /// </summary>
        /// <remarks>
        /// This property is not set if the Job is in its initial Active state.
        /// </remarks>
        [JsonProperty(PropertyName = "previousStateTransitionTime")]
        public System.DateTime? PreviousStateTransitionTime { get; set; }

        /// <summary>
        /// Gets or sets the priority of the Job.
        /// </summary>
        /// <remarks>
        /// Priority values can range from -1000 to 1000, with -1000 being the
        /// lowest priority and 1000 being the highest priority. The default
        /// value is 0.
        /// </remarks>
        [JsonProperty(PropertyName = "priority")]
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets whether Tasks in this job can be preempted by other
        /// high priority jobs
        /// </summary>
        /// <remarks>
        /// If the value is set to True, other high priority jobs submitted to
        /// the system will take precedence and will be able requeue tasks from
        /// this job. You can update a job's allowTaskPreemption after it has
        /// been created using the update job API.
        /// </remarks>
        [JsonProperty(PropertyName = "allowTaskPreemption")]
        public bool? AllowTaskPreemption { get; set; }

        /// <summary>
        /// Gets or sets the maximum number of tasks that can be executed in
        /// parallel for the job.
        /// </summary>
        /// <remarks>
        /// The value of maxParallelTasks must be -1 or greater than 0 if
        /// specified. If not specified, the default value is -1, which means
        /// there's no limit to the number of tasks that can be run at once.
        /// You can update a job's maxParallelTasks after it has been created
        /// using the update job API.
        /// </remarks>
        [JsonProperty(PropertyName = "maxParallelTasks")]
        public int? MaxParallelTasks { get; set; }

        /// <summary>
        /// Gets or sets the execution constraints for the Job.
        /// </summary>
        [JsonProperty(PropertyName = "constraints")]
        public JobConstraints Constraints { get; set; }

        /// <summary>
        /// Gets or sets details of a Job Manager Task to be launched when the
        /// Job is started.
        /// </summary>
        [JsonProperty(PropertyName = "jobManagerTask")]
        public JobManagerTask JobManagerTask { get; set; }

        /// <summary>
        /// Gets or sets the Job Preparation Task.
        /// </summary>
        /// <remarks>
        /// The Job Preparation Task is a special Task run on each Compute Node
        /// before any other Task of the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "jobPreparationTask")]
        public JobPreparationTask JobPreparationTask { get; set; }

        /// <summary>
        /// Gets or sets the Job Release Task.
        /// </summary>
        /// <remarks>
        /// The Job Release Task is a special Task run at the end of the Job on
        /// each Compute Node that has run any other Task of the Job.
        /// </remarks>
        [JsonProperty(PropertyName = "jobReleaseTask")]
        public JobReleaseTask JobReleaseTask { get; set; }

        /// <summary>
        /// Gets or sets the list of common environment variable settings.
        /// These environment variables are set for all Tasks in the Job
        /// (including the Job Manager, Job Preparation and Job Release Tasks).
        /// </summary>
        /// <remarks>
        /// Individual Tasks can override an environment setting specified here
        /// by specifying the same setting name with a different value.
        /// </remarks>
        [JsonProperty(PropertyName = "commonEnvironmentSettings")]
        public IList<EnvironmentSetting> CommonEnvironmentSettings { get; set; }

        /// <summary>
        /// Gets or sets the Pool settings associated with the Job.
        /// </summary>
        [JsonProperty(PropertyName = "poolInfo")]
        public PoolInformation PoolInfo { get; set; }

        /// <summary>
        /// Gets or sets the action the Batch service should take when all
        /// Tasks in the Job are in the completed state.
        /// </summary>
        /// <remarks>
        /// The default is noaction. Possible values include: 'noAction',
        /// 'terminateJob'
        /// </remarks>
        [JsonProperty(PropertyName = "onAllTasksComplete")]
        public OnAllTasksComplete? OnAllTasksComplete { get; set; }

        /// <summary>
        /// Gets or sets the action the Batch service should take when any Task
        /// in the Job fails.
        /// </summary>
        /// <remarks>
        /// A Task is considered to have failed if has a failureInfo. A
        /// failureInfo is set if the Task completes with a non-zero exit code
        /// after exhausting its retry count, or if there was an error starting
        /// the Task, for example due to a resource file download error. The
        /// default is noaction. Possible values include: 'noAction',
        /// 'performExitOptionsJobAction'
        /// </remarks>
        [JsonProperty(PropertyName = "onTaskFailure")]
        public OnTaskFailure? OnTaskFailure { get; set; }

        /// <summary>
        /// Gets or sets the network configuration for the Job.
        /// </summary>
        [JsonProperty(PropertyName = "networkConfiguration")]
        public JobNetworkConfiguration NetworkConfiguration { get; set; }

        /// <summary>
        /// Gets or sets a list of name-value pairs associated with the Job as
        /// metadata.
        /// </summary>
        /// <remarks>
        /// The Batch service does not assign any meaning to metadata; it is
        /// solely for the use of user code.
        /// </remarks>
        [JsonProperty(PropertyName = "metadata")]
        public IList<MetadataItem> Metadata { get; set; }

        /// <summary>
        /// Gets or sets the execution information for the Job.
        /// </summary>
        [JsonProperty(PropertyName = "executionInfo")]
        public JobExecutionInformation ExecutionInfo { get; set; }

        /// <summary>
        /// Gets or sets resource usage statistics for the entire lifetime of
        /// the Job.
        /// </summary>
        /// <remarks>
        /// This property is populated only if the CloudJob was retrieved with
        /// an expand clause including the 'stats' attribute; otherwise it is
        /// null. The statistics may not be immediately available. The Batch
        /// service performs periodic roll-up of statistics. The typical delay
        /// is about 30 minutes.
        /// </remarks>
        [JsonProperty(PropertyName = "stats")]
        public JobStatistics Stats { get; set; }

    }
}
