// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for CertificateVisibility.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum CertificateVisibility
    {
        /// <summary>
        /// The Certificate should be visible to the user account under which
        /// the StartTask is run. Note that if AutoUser Scope is Pool for both
        /// the StartTask and a Task, this certificate will be visible to the
        /// Task as well.
        /// </summary>
        [EnumMember(Value = "starttask")]
        StartTask,
        /// <summary>
        /// The Certificate should be visible to the user accounts under which
        /// Job Tasks are run.
        /// </summary>
        [EnumMember(Value = "task")]
        Task,
        /// <summary>
        /// The Certificate should be visible to the user accounts under which
        /// users remotely access the Compute Node.
        /// </summary>
        [EnumMember(Value = "remoteuser")]
        RemoteUser
    }
    internal static class CertificateVisibilityEnumExtension
    {
        internal static string ToSerializedValue(this CertificateVisibility? value)
        {
            return value == null ? null : ((CertificateVisibility)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this CertificateVisibility value)
        {
            switch( value )
            {
                case CertificateVisibility.StartTask:
                    return "starttask";
                case CertificateVisibility.Task:
                    return "task";
                case CertificateVisibility.RemoteUser:
                    return "remoteuser";
            }
            return null;
        }

        internal static CertificateVisibility? ParseCertificateVisibility(this string value)
        {
            switch( value )
            {
                case "starttask":
                    return CertificateVisibility.StartTask;
                case "task":
                    return CertificateVisibility.Task;
                case "remoteuser":
                    return CertificateVisibility.RemoteUser;
            }
            return null;
        }
    }
}
