// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for CertificateStoreLocation.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum CertificateStoreLocation
    {
        /// <summary>
        /// Certificates should be installed to the CurrentUser Certificate
        /// store.
        /// </summary>
        [EnumMember(Value = "currentuser")]
        CurrentUser,
        /// <summary>
        /// Certificates should be installed to the LocalMachine Certificate
        /// store.
        /// </summary>
        [EnumMember(Value = "localmachine")]
        LocalMachine
    }
    internal static class CertificateStoreLocationEnumExtension
    {
        internal static string ToSerializedValue(this CertificateStoreLocation? value)
        {
            return value == null ? null : ((CertificateStoreLocation)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this CertificateStoreLocation value)
        {
            switch( value )
            {
                case CertificateStoreLocation.CurrentUser:
                    return "currentuser";
                case CertificateStoreLocation.LocalMachine:
                    return "localmachine";
            }
            return null;
        }

        internal static CertificateStoreLocation? ParseCertificateStoreLocation(this string value)
        {
            switch( value )
            {
                case "currentuser":
                    return CertificateStoreLocation.CurrentUser;
                case "localmachine":
                    return CertificateStoreLocation.LocalMachine;
            }
            return null;
        }
    }
}
