// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for CertificateState.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum CertificateState
    {
        /// <summary>
        /// The Certificate is available for use in Pools.
        /// </summary>
        [EnumMember(Value = "active")]
        Active,
        /// <summary>
        /// The user has requested that the Certificate be deleted, but the
        /// delete operation has not yet completed. You may not reference the
        /// Certificate when creating or updating Pools.
        /// </summary>
        [EnumMember(Value = "deleting")]
        Deleting,
        /// <summary>
        /// The user requested that the Certificate be deleted, but there are
        /// Pools that still have references to the Certificate, or it is still
        /// installed on one or more Nodes. (The latter can occur if the
        /// Certificate has been removed from the Pool, but the Compute Node
        /// has not yet restarted. Compute Nodes refresh their Certificates
        /// only when they restart.) You may use the cancel Certificate delete
        /// operation to cancel the delete, or the delete Certificate operation
        /// to retry the delete.
        /// </summary>
        [EnumMember(Value = "deletefailed")]
        DeleteFailed
    }
    internal static class CertificateStateEnumExtension
    {
        internal static string ToSerializedValue(this CertificateState? value)
        {
            return value == null ? null : ((CertificateState)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this CertificateState value)
        {
            switch( value )
            {
                case CertificateState.Active:
                    return "active";
                case CertificateState.Deleting:
                    return "deleting";
                case CertificateState.DeleteFailed:
                    return "deletefailed";
            }
            return null;
        }

        internal static CertificateState? ParseCertificateState(this string value)
        {
            switch( value )
            {
                case "active":
                    return CertificateState.Active;
                case "deleting":
                    return CertificateState.Deleting;
                case "deletefailed":
                    return CertificateState.DeleteFailed;
            }
            return null;
        }
    }
}
