// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A reference to a Certificate to be installed on Compute Nodes in a
    /// Pool.
    /// </summary>
    /// <remarks>
    /// Warning: This object is deprecated and will be removed after February,
    /// 2024. Please use the [Azure KeyVault
    /// Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide)
    /// instead.
    /// </remarks>
    public partial class CertificateReference
    {
        /// <summary>
        /// Initializes a new instance of the CertificateReference class.
        /// </summary>
        public CertificateReference()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the CertificateReference class.
        /// </summary>
        /// <param name="thumbprint">The thumbprint of the Certificate.</param>
        /// <param name="thumbprintAlgorithm">The algorithm with which the
        /// thumbprint is associated. This must be sha1.</param>
        /// <param name="storeLocation">The location of the Certificate store
        /// on the Compute Node into which to install the Certificate.</param>
        /// <param name="storeName">The name of the Certificate store on the
        /// Compute Node into which to install the Certificate.</param>
        /// <param name="visibility">Which user Accounts on the Compute Node
        /// should have access to the private data of the Certificate.</param>
        public CertificateReference(string thumbprint, string thumbprintAlgorithm, CertificateStoreLocation? storeLocation = default(CertificateStoreLocation?), string storeName = default(string), IList<CertificateVisibility> visibility = default(IList<CertificateVisibility>))
        {
            Thumbprint = thumbprint;
            ThumbprintAlgorithm = thumbprintAlgorithm;
            StoreLocation = storeLocation;
            StoreName = storeName;
            Visibility = visibility;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the thumbprint of the Certificate.
        /// </summary>
        [JsonProperty(PropertyName = "thumbprint")]
        public string Thumbprint { get; set; }

        /// <summary>
        /// Gets or sets the algorithm with which the thumbprint is associated.
        /// This must be sha1.
        /// </summary>
        [JsonProperty(PropertyName = "thumbprintAlgorithm")]
        public string ThumbprintAlgorithm { get; set; }

        /// <summary>
        /// Gets or sets the location of the Certificate store on the Compute
        /// Node into which to install the Certificate.
        /// </summary>
        /// <remarks>
        /// The default value is currentuser. This property is applicable only
        /// for Pools configured with Windows Compute Nodes. For Linux Compute
        /// Nodes, the Certificates are stored in a directory inside the Task
        /// working directory and an environment variable
        /// AZ_BATCH_CERTIFICATES_DIR is supplied to the Task to query for this
        /// location. For Certificates with visibility of 'remoteUser', a
        /// 'certs' directory is created in the user's home directory (e.g.,
        /// /home/{user-name}/certs) and Certificates are placed in that
        /// directory. Possible values include: 'currentUser', 'localMachine'
        /// </remarks>
        [JsonProperty(PropertyName = "storeLocation")]
        public CertificateStoreLocation? StoreLocation { get; set; }

        /// <summary>
        /// Gets or sets the name of the Certificate store on the Compute Node
        /// into which to install the Certificate.
        /// </summary>
        /// <remarks>
        /// This property is applicable only for Pools configured with Windows
        /// Compute Nodes. Common store names include: My, Root, CA, Trust,
        /// Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook,
        /// but any custom store name can also be used. The default value is
        /// My.
        /// </remarks>
        [JsonProperty(PropertyName = "storeName")]
        public string StoreName { get; set; }

        /// <summary>
        /// Gets or sets which user Accounts on the Compute Node should have
        /// access to the private data of the Certificate.
        /// </summary>
        /// <remarks>
        /// You can specify more than one visibility in this collection. The
        /// default is all Accounts.
        /// </remarks>
        [JsonProperty(PropertyName = "visibility")]
        public IList<CertificateVisibility> Visibility { get; set; }

    }
}
