// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for CertificateFormat.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum CertificateFormat
    {
        /// <summary>
        /// The Certificate is a PFX (PKCS#12) formatted Certificate or
        /// Certificate chain.
        /// </summary>
        [EnumMember(Value = "pfx")]
        Pfx,
        /// <summary>
        /// The Certificate is a base64-encoded X.509 Certificate.
        /// </summary>
        [EnumMember(Value = "cer")]
        Cer
    }
    internal static class CertificateFormatEnumExtension
    {
        internal static string ToSerializedValue(this CertificateFormat? value)
        {
            return value == null ? null : ((CertificateFormat)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this CertificateFormat value)
        {
            switch( value )
            {
                case CertificateFormat.Pfx:
                    return "pfx";
                case CertificateFormat.Cer:
                    return "cer";
            }
            return null;
        }

        internal static CertificateFormat? ParseCertificateFormat(this string value)
        {
            switch( value )
            {
                case "pfx":
                    return CertificateFormat.Pfx;
                case "cer":
                    return CertificateFormat.Cer;
            }
            return null;
        }
    }
}
