// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The identity of the Batch pool, if configured.
    /// </summary>
    /// <remarks>
    /// The identity of the Batch pool, if configured.
    /// </remarks>
    public partial class BatchPoolIdentity
    {
        /// <summary>
        /// Initializes a new instance of the BatchPoolIdentity class.
        /// </summary>
        public BatchPoolIdentity()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the BatchPoolIdentity class.
        /// </summary>
        /// <param name="type">The identity of the Batch pool, if
        /// configured.</param>
        /// <param name="userAssignedIdentities">The list of user identities
        /// associated with the Batch account.</param>
        public BatchPoolIdentity(PoolIdentityType type, IList<UserAssignedIdentity> userAssignedIdentities = default(IList<UserAssignedIdentity>))
        {
            Type = type;
            UserAssignedIdentities = userAssignedIdentities;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the identity of the Batch pool, if configured.
        /// </summary>
        /// <remarks>
        /// The list of user identities associated with the Batch pool. The
        /// user identity dictionary key references will be ARM resource ids in
        /// the form:
        /// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// Possible values include: 'UserAssigned', 'None'
        /// </remarks>
        [JsonProperty(PropertyName = "type")]
        public PoolIdentityType Type { get; set; }

        /// <summary>
        /// Gets or sets the list of user identities associated with the Batch
        /// account.
        /// </summary>
        /// <remarks>
        /// The user identity dictionary key references will be ARM resource
        /// ids in the form:
        /// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        /// </remarks>
        [JsonProperty(PropertyName = "userAssignedIdentities")]
        public IList<UserAssignedIdentity> UserAssignedIdentities { get; set; }

    }
}
