// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An error response received from the Azure Batch service.
    /// </summary>
    public partial class BatchError
    {
        /// <summary>
        /// Initializes a new instance of the BatchError class.
        /// </summary>
        public BatchError()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the BatchError class.
        /// </summary>
        /// <param name="code">An identifier for the error. Codes are invariant
        /// and are intended to be consumed programmatically.</param>
        /// <param name="message">A message describing the error, intended to
        /// be suitable for display in a user interface.</param>
        /// <param name="values">A collection of key-value pairs containing
        /// additional details about the error.</param>
        public BatchError(string code = default(string), ErrorMessage message = default(ErrorMessage), IList<BatchErrorDetail> values = default(IList<BatchErrorDetail>))
        {
            Code = code;
            Message = message;
            Values = values;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an identifier for the error. Codes are invariant and
        /// are intended to be consumed programmatically.
        /// </summary>
        [JsonProperty(PropertyName = "code")]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a message describing the error, intended to be
        /// suitable for display in a user interface.
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public ErrorMessage Message { get; set; }

        /// <summary>
        /// Gets or sets a collection of key-value pairs containing additional
        /// details about the error.
        /// </summary>
        [JsonProperty(PropertyName = "values")]
        public IList<BatchErrorDetail> Values { get; set; }

    }
}
