// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Information used to connect to an Azure Fileshare.
    /// </summary>
    public partial class AzureFileShareConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the AzureFileShareConfiguration
        /// class.
        /// </summary>
        public AzureFileShareConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AzureFileShareConfiguration
        /// class.
        /// </summary>
        /// <param name="accountName">The Azure Storage account name.</param>
        /// <param name="azureFileUrl">The Azure Files URL.</param>
        /// <param name="accountKey">The Azure Storage account key.</param>
        /// <param name="relativeMountPath">The relative path on the compute
        /// node where the file system will be mounted</param>
        /// <param name="mountOptions">Additional command line options to pass
        /// to the mount command.</param>
        public AzureFileShareConfiguration(string accountName, string azureFileUrl, string accountKey, string relativeMountPath, string mountOptions = default(string))
        {
            AccountName = accountName;
            AzureFileUrl = azureFileUrl;
            AccountKey = accountKey;
            RelativeMountPath = relativeMountPath;
            MountOptions = mountOptions;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the Azure Storage account name.
        /// </summary>
        [JsonProperty(PropertyName = "accountName")]
        public string AccountName { get; set; }

        /// <summary>
        /// Gets or sets the Azure Files URL.
        /// </summary>
        /// <remarks>
        /// This is of the form 'https://{account}.file.core.windows.net/'.
        /// </remarks>
        [JsonProperty(PropertyName = "azureFileUrl")]
        public string AzureFileUrl { get; set; }

        /// <summary>
        /// Gets or sets the Azure Storage account key.
        /// </summary>
        [JsonProperty(PropertyName = "accountKey")]
        public string AccountKey { get; set; }

        /// <summary>
        /// Gets or sets the relative path on the compute node where the file
        /// system will be mounted
        /// </summary>
        /// <remarks>
        /// All file systems are mounted relative to the Batch mounts
        /// directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment
        /// variable.
        /// </remarks>
        [JsonProperty(PropertyName = "relativeMountPath")]
        public string RelativeMountPath { get; set; }

        /// <summary>
        /// Gets or sets additional command line options to pass to the mount
        /// command.
        /// </summary>
        /// <remarks>
        /// These are 'net use' options in Windows and 'mount' options in
        /// Linux.
        /// </remarks>
        [JsonProperty(PropertyName = "mountOptions")]
        public string MountOptions { get; set; }

    }
}
