// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Information used to connect to an Azure Storage Container using
    /// Blobfuse.
    /// </summary>
    public partial class AzureBlobFileSystemConfiguration
    {
        /// <summary>
        /// Initializes a new instance of the AzureBlobFileSystemConfiguration
        /// class.
        /// </summary>
        public AzureBlobFileSystemConfiguration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AzureBlobFileSystemConfiguration
        /// class.
        /// </summary>
        /// <param name="accountName">The Azure Storage Account name.</param>
        /// <param name="containerName">The Azure Blob Storage Container
        /// name.</param>
        /// <param name="relativeMountPath">The relative path on the compute
        /// node where the file system will be mounted</param>
        /// <param name="accountKey">The Azure Storage Account key.</param>
        /// <param name="sasKey">The Azure Storage SAS token.</param>
        /// <param name="blobfuseOptions">Additional command line options to
        /// pass to the mount command.</param>
        /// <param name="identityReference">The reference to the user assigned
        /// identity to use to access containerName</param>
        public AzureBlobFileSystemConfiguration(string accountName, string containerName, string relativeMountPath, string accountKey = default(string), string sasKey = default(string), string blobfuseOptions = default(string), ComputeNodeIdentityReference identityReference = default(ComputeNodeIdentityReference))
        {
            AccountName = accountName;
            ContainerName = containerName;
            AccountKey = accountKey;
            SasKey = sasKey;
            BlobfuseOptions = blobfuseOptions;
            RelativeMountPath = relativeMountPath;
            IdentityReference = identityReference;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the Azure Storage Account name.
        /// </summary>
        [JsonProperty(PropertyName = "accountName")]
        public string AccountName { get; set; }

        /// <summary>
        /// Gets or sets the Azure Blob Storage Container name.
        /// </summary>
        [JsonProperty(PropertyName = "containerName")]
        public string ContainerName { get; set; }

        /// <summary>
        /// Gets or sets the Azure Storage Account key.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with both sasKey and identity;
        /// exactly one must be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "accountKey")]
        public string AccountKey { get; set; }

        /// <summary>
        /// Gets or sets the Azure Storage SAS token.
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with both accountKey and
        /// identity; exactly one must be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "sasKey")]
        public string SasKey { get; set; }

        /// <summary>
        /// Gets or sets additional command line options to pass to the mount
        /// command.
        /// </summary>
        /// <remarks>
        /// These are 'net use' options in Windows and 'mount' options in
        /// Linux.
        /// </remarks>
        [JsonProperty(PropertyName = "blobfuseOptions")]
        public string BlobfuseOptions { get; set; }

        /// <summary>
        /// Gets or sets the relative path on the compute node where the file
        /// system will be mounted
        /// </summary>
        /// <remarks>
        /// All file systems are mounted relative to the Batch mounts
        /// directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment
        /// variable.
        /// </remarks>
        [JsonProperty(PropertyName = "relativeMountPath")]
        public string RelativeMountPath { get; set; }

        /// <summary>
        /// Gets or sets the reference to the user assigned identity to use to
        /// access containerName
        /// </summary>
        /// <remarks>
        /// This property is mutually exclusive with both accountKey and
        /// sasKey; exactly one must be specified.
        /// </remarks>
        [JsonProperty(PropertyName = "identityReference")]
        public ComputeNodeIdentityReference IdentityReference { get; set; }

    }
}
