// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// An error that occurred when executing or evaluating a Pool autoscale
    /// formula.
    /// </summary>
    public partial class AutoScaleRunError
    {
        /// <summary>
        /// Initializes a new instance of the AutoScaleRunError class.
        /// </summary>
        public AutoScaleRunError()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AutoScaleRunError class.
        /// </summary>
        /// <param name="code">An identifier for the autoscale error. Codes are
        /// invariant and are intended to be consumed programmatically.</param>
        /// <param name="message">A message describing the autoscale error,
        /// intended to be suitable for display in a user interface.</param>
        /// <param name="values">A list of additional error details related to
        /// the autoscale error.</param>
        public AutoScaleRunError(string code = default(string), string message = default(string), IList<NameValuePair> values = default(IList<NameValuePair>))
        {
            Code = code;
            Message = message;
            Values = values;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an identifier for the autoscale error. Codes are
        /// invariant and are intended to be consumed programmatically.
        /// </summary>
        [JsonProperty(PropertyName = "code")]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a message describing the autoscale error, intended to
        /// be suitable for display in a user interface.
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets a list of additional error details related to the
        /// autoscale error.
        /// </summary>
        [JsonProperty(PropertyName = "values")]
        public IList<NameValuePair> Values { get; set; }

    }
}
