// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Specifies characteristics for a temporary 'auto pool'. The Batch
    /// service will create this auto Pool when the Job is submitted.
    /// </summary>
    public partial class AutoPoolSpecification
    {
        /// <summary>
        /// Initializes a new instance of the AutoPoolSpecification class.
        /// </summary>
        public AutoPoolSpecification()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AutoPoolSpecification class.
        /// </summary>
        /// <param name="poolLifetimeOption">The minimum lifetime of created
        /// auto Pools, and how multiple Jobs on a schedule are assigned to
        /// Pools.</param>
        /// <param name="autoPoolIdPrefix">A prefix to be added to the unique
        /// identifier when a Pool is automatically created.</param>
        /// <param name="keepAlive">Whether to keep an auto Pool alive after
        /// its lifetime expires.</param>
        /// <param name="pool">The Pool specification for the auto
        /// Pool.</param>
        public AutoPoolSpecification(PoolLifetimeOption poolLifetimeOption, string autoPoolIdPrefix = default(string), bool? keepAlive = default(bool?), PoolSpecification pool = default(PoolSpecification))
        {
            AutoPoolIdPrefix = autoPoolIdPrefix;
            PoolLifetimeOption = poolLifetimeOption;
            KeepAlive = keepAlive;
            Pool = pool;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a prefix to be added to the unique identifier when a
        /// Pool is automatically created.
        /// </summary>
        /// <remarks>
        /// The Batch service assigns each auto Pool a unique identifier on
        /// creation. To distinguish between Pools created for different
        /// purposes, you can specify this element to add a prefix to the ID
        /// that is assigned. The prefix can be up to 20 characters long.
        /// </remarks>
        [JsonProperty(PropertyName = "autoPoolIdPrefix")]
        public string AutoPoolIdPrefix { get; set; }

        /// <summary>
        /// Gets or sets the minimum lifetime of created auto Pools, and how
        /// multiple Jobs on a schedule are assigned to Pools.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'jobSchedule', 'job'
        /// </remarks>
        [JsonProperty(PropertyName = "poolLifetimeOption")]
        public PoolLifetimeOption PoolLifetimeOption { get; set; }

        /// <summary>
        /// Gets or sets whether to keep an auto Pool alive after its lifetime
        /// expires.
        /// </summary>
        /// <remarks>
        /// If false, the Batch service deletes the Pool once its lifetime (as
        /// determined by the poolLifetimeOption setting) expires; that is,
        /// when the Job or Job Schedule completes. If true, the Batch service
        /// does not delete the Pool automatically. It is up to the user to
        /// delete auto Pools created with this option.
        /// </remarks>
        [JsonProperty(PropertyName = "keepAlive")]
        public bool? KeepAlive { get; set; }

        /// <summary>
        /// Gets or sets the Pool specification for the auto Pool.
        /// </summary>
        [JsonProperty(PropertyName = "pool")]
        public PoolSpecification Pool { get; set; }

    }
}
