// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Contains information about an application in an Azure Batch Account.
    /// </summary>
    public partial class ApplicationSummary
    {
        /// <summary>
        /// Initializes a new instance of the ApplicationSummary class.
        /// </summary>
        public ApplicationSummary()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ApplicationSummary class.
        /// </summary>
        /// <param name="id">A string that uniquely identifies the application
        /// within the Account.</param>
        /// <param name="displayName">The display name for the
        /// application.</param>
        /// <param name="versions">The list of available versions of the
        /// application.</param>
        public ApplicationSummary(string id, string displayName, IList<string> versions)
        {
            Id = id;
            DisplayName = displayName;
            Versions = versions;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets a string that uniquely identifies the application
        /// within the Account.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the display name for the application.
        /// </summary>
        [JsonProperty(PropertyName = "displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the list of available versions of the application.
        /// </summary>
        [JsonProperty(PropertyName = "versions")]
        public IList<string> Versions { get; set; }

    }
}
