// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A reference to an Package to be deployed to Compute Nodes.
    /// </summary>
    public partial class ApplicationPackageReference
    {
        /// <summary>
        /// Initializes a new instance of the ApplicationPackageReference
        /// class.
        /// </summary>
        public ApplicationPackageReference()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ApplicationPackageReference
        /// class.
        /// </summary>
        /// <param name="applicationId">The ID of the application to
        /// deploy.</param>
        /// <param name="version">The version of the application to deploy. If
        /// omitted, the default version is deployed.</param>
        public ApplicationPackageReference(string applicationId, string version = default(string))
        {
            ApplicationId = applicationId;
            Version = version;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the ID of the application to deploy.
        /// </summary>
        /// <remarks>
        /// When creating a pool, the package's application ID must be fully
        /// qualified
        /// (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
        /// </remarks>
        [JsonProperty(PropertyName = "applicationId")]
        public string ApplicationId { get; set; }

        /// <summary>
        /// Gets or sets the version of the application to deploy. If omitted,
        /// the default version is deployed.
        /// </summary>
        /// <remarks>
        /// If this is omitted on a Pool, and no default version is specified
        /// for this application, the request fails with the error code
        /// InvalidApplicationPackageReferences and HTTP status code 409. If
        /// this is omitted on a Task, and no default version is specified for
        /// this application, the Task fails with a pre-processing error.
        /// </remarks>
        [JsonProperty(PropertyName = "version")]
        public string Version { get; set; }

    }
}
