// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System.Runtime;
    using System.Runtime.Serialization;

    /// <summary>
    /// Defines values for AllocationState.
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter))]
    public enum AllocationState
    {
        /// <summary>
        /// The Pool is not resizing. There are no changes to the number of
        /// Compute Nodes in the Pool in progress. A Pool enters this state
        /// when it is created and when no operations are being performed on
        /// the Pool to change the number of Compute Nodes.
        /// </summary>
        [EnumMember(Value = "steady")]
        Steady,
        /// <summary>
        /// The Pool is resizing; that is, Compute Nodes are being added to or
        /// removed from the Pool.
        /// </summary>
        [EnumMember(Value = "resizing")]
        Resizing,
        /// <summary>
        /// The Pool was resizing, but the user has requested that the resize
        /// be stopped, but the stop request has not yet been completed.
        /// </summary>
        [EnumMember(Value = "stopping")]
        Stopping
    }
    internal static class AllocationStateEnumExtension
    {
        internal static string ToSerializedValue(this AllocationState? value)
        {
            return value == null ? null : ((AllocationState)value).ToSerializedValue();
        }

        internal static string ToSerializedValue(this AllocationState value)
        {
            switch( value )
            {
                case AllocationState.Steady:
                    return "steady";
                case AllocationState.Resizing:
                    return "resizing";
                case AllocationState.Stopping:
                    return "stopping";
            }
            return null;
        }

        internal static AllocationState? ParseAllocationState(this string value)
        {
            switch( value )
            {
                case "steady":
                    return AllocationState.Steady;
                case "resizing":
                    return AllocationState.Resizing;
                case "stopping":
                    return AllocationState.Stopping;
            }
            return null;
        }
    }
}
