// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// A locality hint that can be used by the Batch service to select a
    /// Compute Node on which to start a Task.
    /// </summary>
    public partial class AffinityInformation
    {
        /// <summary>
        /// Initializes a new instance of the AffinityInformation class.
        /// </summary>
        public AffinityInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the AffinityInformation class.
        /// </summary>
        /// <param name="affinityId">An opaque string representing the location
        /// of a Compute Node or a Task that has run previously.</param>
        public AffinityInformation(string affinityId)
        {
            AffinityId = affinityId;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an opaque string representing the location of a
        /// Compute Node or a Task that has run previously.
        /// </summary>
        /// <remarks>
        /// You can pass the affinityId of a Node to indicate that this Task
        /// needs to run on that Compute Node. Note that this is just a soft
        /// affinity. If the target Compute Node is busy or unavailable at the
        /// time the Task is scheduled, then the Task will be scheduled
        /// elsewhere.
        /// </remarks>
        [JsonProperty(PropertyName = "affinityId")]
        public string AffinityId { get; set; }

    }
}
