// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for JobScheduleOperations.
    /// </summary>
    public static partial class JobScheduleOperationsExtensions
    {
            /// <summary>
            /// Checks the specified Job Schedule exists.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule which you want to check.
            /// </param>
            /// <param name='jobScheduleExistsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static bool Exists(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions = default(JobScheduleExistsOptions))
            {
                return operations.ExistsAsync(jobScheduleId, jobScheduleExistsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Checks the specified Job Schedule exists.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule which you want to check.
            /// </param>
            /// <param name='jobScheduleExistsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<bool> ExistsAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions = default(JobScheduleExistsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ExistsWithHttpMessagesAsync(jobScheduleId, jobScheduleExistsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes a Job Schedule from the specified Account.
            /// </summary>
            /// <remarks>
            /// When you delete a Job Schedule, this also deletes all Jobs and Tasks under
            /// that schedule. When Tasks are deleted, all the files in their working
            /// directories on the Compute Nodes are also deleted (the retention period is
            /// ignored). The Job Schedule statistics are no longer accessible once the Job
            /// Schedule is deleted, though they are still counted towards Account lifetime
            /// statistics.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to delete.
            /// </param>
            /// <param name='jobScheduleDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleDeleteHeaders Delete(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions = default(JobScheduleDeleteOptions))
            {
                return operations.DeleteAsync(jobScheduleId, jobScheduleDeleteOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes a Job Schedule from the specified Account.
            /// </summary>
            /// <remarks>
            /// When you delete a Job Schedule, this also deletes all Jobs and Tasks under
            /// that schedule. When Tasks are deleted, all the files in their working
            /// directories on the Compute Nodes are also deleted (the retention period is
            /// ignored). The Job Schedule statistics are no longer accessible once the Job
            /// Schedule is deleted, though they are still counted towards Account lifetime
            /// statistics.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to delete.
            /// </param>
            /// <param name='jobScheduleDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleDeleteHeaders> DeleteAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions = default(JobScheduleDeleteOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteWithHttpMessagesAsync(jobScheduleId, jobScheduleDeleteOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets information about the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to get.
            /// </param>
            /// <param name='jobScheduleGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static CloudJobSchedule Get(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions = default(JobScheduleGetOptions))
            {
                return operations.GetAsync(jobScheduleId, jobScheduleGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to get.
            /// </param>
            /// <param name='jobScheduleGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<CloudJobSchedule> GetAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions = default(JobScheduleGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(jobScheduleId, jobScheduleGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Job Schedule.
            /// </summary>
            /// <remarks>
            /// This replaces only the Job Schedule properties specified in the request.
            /// For example, if the schedule property is not specified with this request,
            /// then the Batch service will keep the existing schedule. Changes to a Job
            /// Schedule only impact Jobs created by the schedule after the update has
            /// taken place; currently running Jobs are unaffected.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to update.
            /// </param>
            /// <param name='jobSchedulePatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobSchedulePatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobSchedulePatchHeaders Patch(this IJobScheduleOperations operations, string jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions = default(JobSchedulePatchOptions))
            {
                return operations.PatchAsync(jobScheduleId, jobSchedulePatchParameter, jobSchedulePatchOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Job Schedule.
            /// </summary>
            /// <remarks>
            /// This replaces only the Job Schedule properties specified in the request.
            /// For example, if the schedule property is not specified with this request,
            /// then the Batch service will keep the existing schedule. Changes to a Job
            /// Schedule only impact Jobs created by the schedule after the update has
            /// taken place; currently running Jobs are unaffected.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to update.
            /// </param>
            /// <param name='jobSchedulePatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobSchedulePatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobSchedulePatchHeaders> PatchAsync(this IJobScheduleOperations operations, string jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions = default(JobSchedulePatchOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.PatchWithHttpMessagesAsync(jobScheduleId, jobSchedulePatchParameter, jobSchedulePatchOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Job Schedule.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Job Schedule. For
            /// example, if the schedule property is not specified with this request, then
            /// the Batch service will remove the existing schedule. Changes to a Job
            /// Schedule only impact Jobs created by the schedule after the update has
            /// taken place; currently running Jobs are unaffected.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to update.
            /// </param>
            /// <param name='jobScheduleUpdateParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobScheduleUpdateOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleUpdateHeaders Update(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions = default(JobScheduleUpdateOptions))
            {
                return operations.UpdateAsync(jobScheduleId, jobScheduleUpdateParameter, jobScheduleUpdateOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Job Schedule.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Job Schedule. For
            /// example, if the schedule property is not specified with this request, then
            /// the Batch service will remove the existing schedule. Changes to a Job
            /// Schedule only impact Jobs created by the schedule after the update has
            /// taken place; currently running Jobs are unaffected.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to update.
            /// </param>
            /// <param name='jobScheduleUpdateParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobScheduleUpdateOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleUpdateHeaders> UpdateAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions = default(JobScheduleUpdateOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(jobScheduleId, jobScheduleUpdateParameter, jobScheduleUpdateOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Disables a Job Schedule.
            /// </summary>
            /// <remarks>
            /// No new Jobs will be created until the Job Schedule is enabled again.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to disable.
            /// </param>
            /// <param name='jobScheduleDisableOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleDisableHeaders Disable(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions = default(JobScheduleDisableOptions))
            {
                return operations.DisableAsync(jobScheduleId, jobScheduleDisableOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Disables a Job Schedule.
            /// </summary>
            /// <remarks>
            /// No new Jobs will be created until the Job Schedule is enabled again.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to disable.
            /// </param>
            /// <param name='jobScheduleDisableOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleDisableHeaders> DisableAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions = default(JobScheduleDisableOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DisableWithHttpMessagesAsync(jobScheduleId, jobScheduleDisableOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Enables a Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to enable.
            /// </param>
            /// <param name='jobScheduleEnableOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleEnableHeaders Enable(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions = default(JobScheduleEnableOptions))
            {
                return operations.EnableAsync(jobScheduleId, jobScheduleEnableOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Enables a Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to enable.
            /// </param>
            /// <param name='jobScheduleEnableOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleEnableHeaders> EnableAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions = default(JobScheduleEnableOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EnableWithHttpMessagesAsync(jobScheduleId, jobScheduleEnableOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Terminates a Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to terminates.
            /// </param>
            /// <param name='jobScheduleTerminateOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleTerminateHeaders Terminate(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions = default(JobScheduleTerminateOptions))
            {
                return operations.TerminateAsync(jobScheduleId, jobScheduleTerminateOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Terminates a Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule to terminates.
            /// </param>
            /// <param name='jobScheduleTerminateOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleTerminateHeaders> TerminateAsync(this IJobScheduleOperations operations, string jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions = default(JobScheduleTerminateOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.TerminateWithHttpMessagesAsync(jobScheduleId, jobScheduleTerminateOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Adds a Job Schedule to the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cloudJobSchedule'>
            /// The Job Schedule to be added.
            /// </param>
            /// <param name='jobScheduleAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobScheduleAddHeaders Add(this IJobScheduleOperations operations, JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions = default(JobScheduleAddOptions))
            {
                return operations.AddAsync(cloudJobSchedule, jobScheduleAddOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Adds a Job Schedule to the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cloudJobSchedule'>
            /// The Job Schedule to be added.
            /// </param>
            /// <param name='jobScheduleAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobScheduleAddHeaders> AddAsync(this IJobScheduleOperations operations, JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions = default(JobScheduleAddOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddWithHttpMessagesAsync(cloudJobSchedule, jobScheduleAddOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Lists all of the Job Schedules in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJobSchedule> List(this IJobScheduleOperations operations, JobScheduleListOptions jobScheduleListOptions = default(JobScheduleListOptions))
            {
                return operations.ListAsync(jobScheduleListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Job Schedules in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJobSchedule>> ListAsync(this IJobScheduleOperations operations, JobScheduleListOptions jobScheduleListOptions = default(JobScheduleListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(jobScheduleListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists all of the Job Schedules in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobScheduleListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJobSchedule> ListNext(this IJobScheduleOperations operations, string nextPageLink, JobScheduleListNextOptions jobScheduleListNextOptions = default(JobScheduleListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, jobScheduleListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Job Schedules in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobScheduleListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJobSchedule>> ListNextAsync(this IJobScheduleOperations operations, string nextPageLink, JobScheduleListNextOptions jobScheduleListNextOptions = default(JobScheduleListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, jobScheduleListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
