// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for JobOperations.
    /// </summary>
    public static partial class JobOperationsExtensions
    {
            /// <summary>
            /// Deletes a Job.
            /// </summary>
            /// <remarks>
            /// Deleting a Job also deletes all Tasks that are part of that Job, and all
            /// Job statistics. This also overrides the retention period for Task data;
            /// that is, if the Job contains Tasks which are still retained on Compute
            /// Nodes, the Batch services deletes those Tasks' working directories and all
            /// their contents.  When a Delete Job request is received, the Batch service
            /// sets the Job to the deleting state. All update operations on a Job that is
            /// in deleting state will fail with status code 409 (Conflict), with
            /// additional information indicating that the Job is being deleted.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to delete.
            /// </param>
            /// <param name='jobDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobDeleteHeaders Delete(this IJobOperations operations, string jobId, JobDeleteOptions jobDeleteOptions = default(JobDeleteOptions))
            {
                return operations.DeleteAsync(jobId, jobDeleteOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes a Job.
            /// </summary>
            /// <remarks>
            /// Deleting a Job also deletes all Tasks that are part of that Job, and all
            /// Job statistics. This also overrides the retention period for Task data;
            /// that is, if the Job contains Tasks which are still retained on Compute
            /// Nodes, the Batch services deletes those Tasks' working directories and all
            /// their contents.  When a Delete Job request is received, the Batch service
            /// sets the Job to the deleting state. All update operations on a Job that is
            /// in deleting state will fail with status code 409 (Conflict), with
            /// additional information indicating that the Job is being deleted.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to delete.
            /// </param>
            /// <param name='jobDeleteOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobDeleteHeaders> DeleteAsync(this IJobOperations operations, string jobId, JobDeleteOptions jobDeleteOptions = default(JobDeleteOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteWithHttpMessagesAsync(jobId, jobDeleteOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets information about the specified Job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static CloudJob Get(this IJobOperations operations, string jobId, JobGetOptions jobGetOptions = default(JobGetOptions))
            {
                return operations.GetAsync(jobId, jobGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Job.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<CloudJob> GetAsync(this IJobOperations operations, string jobId, JobGetOptions jobGetOptions = default(JobGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(jobId, jobGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Job.
            /// </summary>
            /// <remarks>
            /// This replaces only the Job properties specified in the request. For
            /// example, if the Job has constraints, and a request does not specify the
            /// constraints element, then the Job keeps the existing constraints.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job whose properties you want to update.
            /// </param>
            /// <param name='jobPatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobPatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobPatchHeaders Patch(this IJobOperations operations, string jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions = default(JobPatchOptions))
            {
                return operations.PatchAsync(jobId, jobPatchParameter, jobPatchOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Job.
            /// </summary>
            /// <remarks>
            /// This replaces only the Job properties specified in the request. For
            /// example, if the Job has constraints, and a request does not specify the
            /// constraints element, then the Job keeps the existing constraints.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job whose properties you want to update.
            /// </param>
            /// <param name='jobPatchParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobPatchOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobPatchHeaders> PatchAsync(this IJobOperations operations, string jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions = default(JobPatchOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.PatchWithHttpMessagesAsync(jobId, jobPatchParameter, jobPatchOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Updates the properties of the specified Job.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Job. For example,
            /// if the Job has constraints associated with it and if constraints is not
            /// specified with this request, then the Batch service will remove the
            /// existing constraints.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job whose properties you want to update.
            /// </param>
            /// <param name='jobUpdateParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobUpdateOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobUpdateHeaders Update(this IJobOperations operations, string jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions = default(JobUpdateOptions))
            {
                return operations.UpdateAsync(jobId, jobUpdateParameter, jobUpdateOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the properties of the specified Job.
            /// </summary>
            /// <remarks>
            /// This fully replaces all the updatable properties of the Job. For example,
            /// if the Job has constraints associated with it and if constraints is not
            /// specified with this request, then the Batch service will remove the
            /// existing constraints.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job whose properties you want to update.
            /// </param>
            /// <param name='jobUpdateParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='jobUpdateOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobUpdateHeaders> UpdateAsync(this IJobOperations operations, string jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions = default(JobUpdateOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(jobId, jobUpdateParameter, jobUpdateOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Disables the specified Job, preventing new Tasks from running.
            /// </summary>
            /// <remarks>
            /// The Batch Service immediately moves the Job to the disabling state. Batch
            /// then uses the disableTasks parameter to determine what to do with the
            /// currently running Tasks of the Job. The Job remains in the disabling state
            /// until the disable operation is completed and all Tasks have been dealt with
            /// according to the disableTasks option; the Job then moves to the disabled
            /// state. No new Tasks are started under the Job until it moves back to active
            /// state. If you try to disable a Job that is in any state other than active,
            /// disabling, or disabled, the request fails with status code 409.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to disable.
            /// </param>
            /// <param name='disableTasks'>
            /// What to do with active Tasks associated with the Job. Possible values
            /// include: 'requeue', 'terminate', 'wait'
            /// </param>
            /// <param name='jobDisableOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobDisableHeaders Disable(this IJobOperations operations, string jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions = default(JobDisableOptions))
            {
                return operations.DisableAsync(jobId, disableTasks, jobDisableOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Disables the specified Job, preventing new Tasks from running.
            /// </summary>
            /// <remarks>
            /// The Batch Service immediately moves the Job to the disabling state. Batch
            /// then uses the disableTasks parameter to determine what to do with the
            /// currently running Tasks of the Job. The Job remains in the disabling state
            /// until the disable operation is completed and all Tasks have been dealt with
            /// according to the disableTasks option; the Job then moves to the disabled
            /// state. No new Tasks are started under the Job until it moves back to active
            /// state. If you try to disable a Job that is in any state other than active,
            /// disabling, or disabled, the request fails with status code 409.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to disable.
            /// </param>
            /// <param name='disableTasks'>
            /// What to do with active Tasks associated with the Job. Possible values
            /// include: 'requeue', 'terminate', 'wait'
            /// </param>
            /// <param name='jobDisableOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobDisableHeaders> DisableAsync(this IJobOperations operations, string jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions = default(JobDisableOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DisableWithHttpMessagesAsync(jobId, disableTasks, jobDisableOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Enables the specified Job, allowing new Tasks to run.
            /// </summary>
            /// <remarks>
            /// When you call this API, the Batch service sets a disabled Job to the
            /// enabling state. After the this operation is completed, the Job moves to the
            /// active state, and scheduling of new Tasks under the Job resumes. The Batch
            /// service does not allow a Task to remain in the active state for more than
            /// 180 days. Therefore, if you enable a Job containing active Tasks which were
            /// added more than 180 days ago, those Tasks will not run.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to enable.
            /// </param>
            /// <param name='jobEnableOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobEnableHeaders Enable(this IJobOperations operations, string jobId, JobEnableOptions jobEnableOptions = default(JobEnableOptions))
            {
                return operations.EnableAsync(jobId, jobEnableOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Enables the specified Job, allowing new Tasks to run.
            /// </summary>
            /// <remarks>
            /// When you call this API, the Batch service sets a disabled Job to the
            /// enabling state. After the this operation is completed, the Job moves to the
            /// active state, and scheduling of new Tasks under the Job resumes. The Batch
            /// service does not allow a Task to remain in the active state for more than
            /// 180 days. Therefore, if you enable a Job containing active Tasks which were
            /// added more than 180 days ago, those Tasks will not run.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to enable.
            /// </param>
            /// <param name='jobEnableOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobEnableHeaders> EnableAsync(this IJobOperations operations, string jobId, JobEnableOptions jobEnableOptions = default(JobEnableOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EnableWithHttpMessagesAsync(jobId, jobEnableOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Terminates the specified Job, marking it as completed.
            /// </summary>
            /// <remarks>
            /// When a Terminate Job request is received, the Batch service sets the Job to
            /// the terminating state. The Batch service then terminates any running Tasks
            /// associated with the Job and runs any required Job release Tasks. Then the
            /// Job moves into the completed state. If there are any Tasks in the Job in
            /// the active state, they will remain in the active state. Once a Job is
            /// terminated, new Tasks cannot be added and any remaining active Tasks will
            /// not be scheduled.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to terminate.
            /// </param>
            /// <param name='terminateReason'>
            /// The text you want to appear as the Job's TerminateReason. The default is
            /// 'UserTerminate'.
            /// </param>
            /// <param name='jobTerminateOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobTerminateHeaders Terminate(this IJobOperations operations, string jobId, string terminateReason = default(string), JobTerminateOptions jobTerminateOptions = default(JobTerminateOptions))
            {
                return operations.TerminateAsync(jobId, terminateReason, jobTerminateOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Terminates the specified Job, marking it as completed.
            /// </summary>
            /// <remarks>
            /// When a Terminate Job request is received, the Batch service sets the Job to
            /// the terminating state. The Batch service then terminates any running Tasks
            /// associated with the Job and runs any required Job release Tasks. Then the
            /// Job moves into the completed state. If there are any Tasks in the Job in
            /// the active state, they will remain in the active state. Once a Job is
            /// terminated, new Tasks cannot be added and any remaining active Tasks will
            /// not be scheduled.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job to terminate.
            /// </param>
            /// <param name='terminateReason'>
            /// The text you want to appear as the Job's TerminateReason. The default is
            /// 'UserTerminate'.
            /// </param>
            /// <param name='jobTerminateOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobTerminateHeaders> TerminateAsync(this IJobOperations operations, string jobId, string terminateReason = default(string), JobTerminateOptions jobTerminateOptions = default(JobTerminateOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.TerminateWithHttpMessagesAsync(jobId, terminateReason, jobTerminateOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Adds a Job to the specified Account.
            /// </summary>
            /// <remarks>
            /// The Batch service supports two ways to control the work done as part of a
            /// Job. In the first approach, the user specifies a Job Manager Task. The
            /// Batch service launches this Task when it is ready to start the Job. The Job
            /// Manager Task controls all other Tasks that run under this Job, by using the
            /// Task APIs. In the second approach, the user directly controls the execution
            /// of Tasks under an active Job, by using the Task APIs. Also note: when
            /// naming Jobs, avoid including sensitive information such as user names or
            /// secret project names. This information may appear in telemetry logs
            /// accessible to Microsoft Support engineers.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='job'>
            /// The Job to be added.
            /// </param>
            /// <param name='jobAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static JobAddHeaders Add(this IJobOperations operations, JobAddParameter job, JobAddOptions jobAddOptions = default(JobAddOptions))
            {
                return operations.AddAsync(job, jobAddOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Adds a Job to the specified Account.
            /// </summary>
            /// <remarks>
            /// The Batch service supports two ways to control the work done as part of a
            /// Job. In the first approach, the user specifies a Job Manager Task. The
            /// Batch service launches this Task when it is ready to start the Job. The Job
            /// Manager Task controls all other Tasks that run under this Job, by using the
            /// Task APIs. In the second approach, the user directly controls the execution
            /// of Tasks under an active Job, by using the Task APIs. Also note: when
            /// naming Jobs, avoid including sensitive information such as user names or
            /// secret project names. This information may appear in telemetry logs
            /// accessible to Microsoft Support engineers.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='job'>
            /// The Job to be added.
            /// </param>
            /// <param name='jobAddOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobAddHeaders> AddAsync(this IJobOperations operations, JobAddParameter job, JobAddOptions jobAddOptions = default(JobAddOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddWithHttpMessagesAsync(job, jobAddOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Lists all of the Jobs in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJob> List(this IJobOperations operations, JobListOptions jobListOptions = default(JobListOptions))
            {
                return operations.ListAsync(jobListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Jobs in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJob>> ListAsync(this IJobOperations operations, JobListOptions jobListOptions = default(JobListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(jobListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Jobs that have been created under the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule from which you want to get a list of Jobs.
            /// </param>
            /// <param name='jobListFromJobScheduleOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJob> ListFromJobSchedule(this IJobOperations operations, string jobScheduleId, JobListFromJobScheduleOptions jobListFromJobScheduleOptions = default(JobListFromJobScheduleOptions))
            {
                return operations.ListFromJobScheduleAsync(jobScheduleId, jobListFromJobScheduleOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Jobs that have been created under the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobScheduleId'>
            /// The ID of the Job Schedule from which you want to get a list of Jobs.
            /// </param>
            /// <param name='jobListFromJobScheduleOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJob>> ListFromJobScheduleAsync(this IJobOperations operations, string jobScheduleId, JobListFromJobScheduleOptions jobListFromJobScheduleOptions = default(JobListFromJobScheduleOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListFromJobScheduleWithHttpMessagesAsync(jobScheduleId, jobListFromJobScheduleOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the execution status of the Job Preparation and Job Release Task for
            /// the specified Job across the Compute Nodes where the Job has run.
            /// </summary>
            /// <remarks>
            /// This API returns the Job Preparation and Job Release Task status on all
            /// Compute Nodes that have run the Job Preparation or Job Release Task. This
            /// includes Compute Nodes which have since been removed from the Pool. If this
            /// API is invoked on a Job which has no Job Preparation or Job Release Task,
            /// the Batch service returns HTTP status code 409 (Conflict) with an error
            /// code of JobPreparationTaskNotSpecified.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobListPreparationAndReleaseTaskStatusOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<JobPreparationAndReleaseTaskExecutionInformation> ListPreparationAndReleaseTaskStatus(this IJobOperations operations, string jobId, JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions = default(JobListPreparationAndReleaseTaskStatusOptions))
            {
                return operations.ListPreparationAndReleaseTaskStatusAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the execution status of the Job Preparation and Job Release Task for
            /// the specified Job across the Compute Nodes where the Job has run.
            /// </summary>
            /// <remarks>
            /// This API returns the Job Preparation and Job Release Task status on all
            /// Compute Nodes that have run the Job Preparation or Job Release Task. This
            /// includes Compute Nodes which have since been removed from the Pool. If this
            /// API is invoked on a Job which has no Job Preparation or Job Release Task,
            /// the Batch service returns HTTP status code 409 (Conflict) with an error
            /// code of JobPreparationTaskNotSpecified.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobListPreparationAndReleaseTaskStatusOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<JobPreparationAndReleaseTaskExecutionInformation>> ListPreparationAndReleaseTaskStatusAsync(this IJobOperations operations, string jobId, JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions = default(JobListPreparationAndReleaseTaskStatusOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPreparationAndReleaseTaskStatusWithHttpMessagesAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the Task counts for the specified Job.
            /// </summary>
            /// <remarks>
            /// Task counts provide a count of the Tasks by active, running or completed
            /// Task state, and a count of Tasks which succeeded or failed. Tasks in the
            /// preparing state are counted as running. Note that the numbers returned may
            /// not always be up to date. If you need exact task counts, use a list query.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobGetTaskCountsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static TaskCountsResult GetTaskCounts(this IJobOperations operations, string jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions = default(JobGetTaskCountsOptions))
            {
                return operations.GetTaskCountsAsync(jobId, jobGetTaskCountsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the Task counts for the specified Job.
            /// </summary>
            /// <remarks>
            /// Task counts provide a count of the Tasks by active, running or completed
            /// Task state, and a count of Tasks which succeeded or failed. Tasks in the
            /// preparing state are counted as running. Note that the numbers returned may
            /// not always be up to date. If you need exact task counts, use a list query.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='jobId'>
            /// The ID of the Job.
            /// </param>
            /// <param name='jobGetTaskCountsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<TaskCountsResult> GetTaskCountsAsync(this IJobOperations operations, string jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions = default(JobGetTaskCountsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTaskCountsWithHttpMessagesAsync(jobId, jobGetTaskCountsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists all of the Jobs in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJob> ListNext(this IJobOperations operations, string nextPageLink, JobListNextOptions jobListNextOptions = default(JobListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, jobListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the Jobs in the specified Account.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJob>> ListNextAsync(this IJobOperations operations, string nextPageLink, JobListNextOptions jobListNextOptions = default(JobListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, jobListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Jobs that have been created under the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListFromJobScheduleNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<CloudJob> ListFromJobScheduleNext(this IJobOperations operations, string nextPageLink, JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = default(JobListFromJobScheduleNextOptions))
            {
                return operations.ListFromJobScheduleNextAsync(nextPageLink, jobListFromJobScheduleNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Jobs that have been created under the specified Job Schedule.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListFromJobScheduleNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<CloudJob>> ListFromJobScheduleNextAsync(this IJobOperations operations, string nextPageLink, JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = default(JobListFromJobScheduleNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListFromJobScheduleNextWithHttpMessagesAsync(nextPageLink, jobListFromJobScheduleNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the execution status of the Job Preparation and Job Release Task for
            /// the specified Job across the Compute Nodes where the Job has run.
            /// </summary>
            /// <remarks>
            /// This API returns the Job Preparation and Job Release Task status on all
            /// Compute Nodes that have run the Job Preparation or Job Release Task. This
            /// includes Compute Nodes which have since been removed from the Pool. If this
            /// API is invoked on a Job which has no Job Preparation or Job Release Task,
            /// the Batch service returns HTTP status code 409 (Conflict) with an error
            /// code of JobPreparationTaskNotSpecified.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListPreparationAndReleaseTaskStatusNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<JobPreparationAndReleaseTaskExecutionInformation> ListPreparationAndReleaseTaskStatusNext(this IJobOperations operations, string nextPageLink, JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = default(JobListPreparationAndReleaseTaskStatusNextOptions))
            {
                return operations.ListPreparationAndReleaseTaskStatusNextAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the execution status of the Job Preparation and Job Release Task for
            /// the specified Job across the Compute Nodes where the Job has run.
            /// </summary>
            /// <remarks>
            /// This API returns the Job Preparation and Job Release Task status on all
            /// Compute Nodes that have run the Job Preparation or Job Release Task. This
            /// includes Compute Nodes which have since been removed from the Pool. If this
            /// API is invoked on a Job which has no Job Preparation or Job Release Task,
            /// the Batch service returns HTTP status code 409 (Conflict) with an error
            /// code of JobPreparationTaskNotSpecified.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='jobListPreparationAndReleaseTaskStatusNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<JobPreparationAndReleaseTaskExecutionInformation>> ListPreparationAndReleaseTaskStatusNextAsync(this IJobOperations operations, string nextPageLink, JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = default(JobListPreparationAndReleaseTaskStatusNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPreparationAndReleaseTaskStatusNextWithHttpMessagesAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
