// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// JobOperations operations.
    /// </summary>
    public partial interface IJobOperations
    {
        /// <summary>
        /// Deletes a Job.
        /// </summary>
        /// <remarks>
        /// Deleting a Job also deletes all Tasks that are part of that Job,
        /// and all Job statistics. This also overrides the retention period
        /// for Task data; that is, if the Job contains Tasks which are still
        /// retained on Compute Nodes, the Batch services deletes those Tasks'
        /// working directories and all their contents.  When a Delete Job
        /// request is received, the Batch service sets the Job to the deleting
        /// state. All update operations on a Job that is in deleting state
        /// will fail with status code 409 (Conflict), with additional
        /// information indicating that the Job is being deleted.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job to delete.
        /// </param>
        /// <param name='jobDeleteOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobDeleteHeaders>> DeleteWithHttpMessagesAsync(string jobId, JobDeleteOptions jobDeleteOptions = default(JobDeleteOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Gets information about the specified Job.
        /// </summary>
        /// <param name='jobId'>
        /// The ID of the Job.
        /// </param>
        /// <param name='jobGetOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<CloudJob,JobGetHeaders>> GetWithHttpMessagesAsync(string jobId, JobGetOptions jobGetOptions = default(JobGetOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Updates the properties of the specified Job.
        /// </summary>
        /// <remarks>
        /// This replaces only the Job properties specified in the request. For
        /// example, if the Job has constraints, and a request does not specify
        /// the constraints element, then the Job keeps the existing
        /// constraints.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job whose properties you want to update.
        /// </param>
        /// <param name='jobPatchParameter'>
        /// The parameters for the request.
        /// </param>
        /// <param name='jobPatchOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobPatchHeaders>> PatchWithHttpMessagesAsync(string jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions = default(JobPatchOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Updates the properties of the specified Job.
        /// </summary>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Job. For
        /// example, if the Job has constraints associated with it and if
        /// constraints is not specified with this request, then the Batch
        /// service will remove the existing constraints.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job whose properties you want to update.
        /// </param>
        /// <param name='jobUpdateParameter'>
        /// The parameters for the request.
        /// </param>
        /// <param name='jobUpdateOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobUpdateHeaders>> UpdateWithHttpMessagesAsync(string jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions = default(JobUpdateOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Disables the specified Job, preventing new Tasks from running.
        /// </summary>
        /// <remarks>
        /// The Batch Service immediately moves the Job to the disabling state.
        /// Batch then uses the disableTasks parameter to determine what to do
        /// with the currently running Tasks of the Job. The Job remains in the
        /// disabling state until the disable operation is completed and all
        /// Tasks have been dealt with according to the disableTasks option;
        /// the Job then moves to the disabled state. No new Tasks are started
        /// under the Job until it moves back to active state. If you try to
        /// disable a Job that is in any state other than active, disabling, or
        /// disabled, the request fails with status code 409.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job to disable.
        /// </param>
        /// <param name='disableTasks'>
        /// What to do with active Tasks associated with the Job. Possible
        /// values include: 'requeue', 'terminate', 'wait'
        /// </param>
        /// <param name='jobDisableOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobDisableHeaders>> DisableWithHttpMessagesAsync(string jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions = default(JobDisableOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Enables the specified Job, allowing new Tasks to run.
        /// </summary>
        /// <remarks>
        /// When you call this API, the Batch service sets a disabled Job to
        /// the enabling state. After the this operation is completed, the Job
        /// moves to the active state, and scheduling of new Tasks under the
        /// Job resumes. The Batch service does not allow a Task to remain in
        /// the active state for more than 180 days. Therefore, if you enable a
        /// Job containing active Tasks which were added more than 180 days
        /// ago, those Tasks will not run.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job to enable.
        /// </param>
        /// <param name='jobEnableOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobEnableHeaders>> EnableWithHttpMessagesAsync(string jobId, JobEnableOptions jobEnableOptions = default(JobEnableOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Terminates the specified Job, marking it as completed.
        /// </summary>
        /// <remarks>
        /// When a Terminate Job request is received, the Batch service sets
        /// the Job to the terminating state. The Batch service then terminates
        /// any running Tasks associated with the Job and runs any required Job
        /// release Tasks. Then the Job moves into the completed state. If
        /// there are any Tasks in the Job in the active state, they will
        /// remain in the active state. Once a Job is terminated, new Tasks
        /// cannot be added and any remaining active Tasks will not be
        /// scheduled.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job to terminate.
        /// </param>
        /// <param name='terminateReason'>
        /// The text you want to appear as the Job's TerminateReason. The
        /// default is 'UserTerminate'.
        /// </param>
        /// <param name='jobTerminateOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobTerminateHeaders>> TerminateWithHttpMessagesAsync(string jobId, string terminateReason = default(string), JobTerminateOptions jobTerminateOptions = default(JobTerminateOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Adds a Job to the specified Account.
        /// </summary>
        /// <remarks>
        /// The Batch service supports two ways to control the work done as
        /// part of a Job. In the first approach, the user specifies a Job
        /// Manager Task. The Batch service launches this Task when it is ready
        /// to start the Job. The Job Manager Task controls all other Tasks
        /// that run under this Job, by using the Task APIs. In the second
        /// approach, the user directly controls the execution of Tasks under
        /// an active Job, by using the Task APIs. Also note: when naming Jobs,
        /// avoid including sensitive information such as user names or secret
        /// project names. This information may appear in telemetry logs
        /// accessible to Microsoft Support engineers.
        /// </remarks>
        /// <param name='job'>
        /// The Job to be added.
        /// </param>
        /// <param name='jobAddOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<JobAddHeaders>> AddWithHttpMessagesAsync(JobAddParameter job, JobAddOptions jobAddOptions = default(JobAddOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists all of the Jobs in the specified Account.
        /// </summary>
        /// <param name='jobListOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<CloudJob>,JobListHeaders>> ListWithHttpMessagesAsync(JobListOptions jobListOptions = default(JobListOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Jobs that have been created under the specified Job
        /// Schedule.
        /// </summary>
        /// <param name='jobScheduleId'>
        /// The ID of the Job Schedule from which you want to get a list of
        /// Jobs.
        /// </param>
        /// <param name='jobListFromJobScheduleOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<CloudJob>,JobListFromJobScheduleHeaders>> ListFromJobScheduleWithHttpMessagesAsync(string jobScheduleId, JobListFromJobScheduleOptions jobListFromJobScheduleOptions = default(JobListFromJobScheduleOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the execution status of the Job Preparation and Job Release
        /// Task for the specified Job across the Compute Nodes where the Job
        /// has run.
        /// </summary>
        /// <remarks>
        /// This API returns the Job Preparation and Job Release Task status on
        /// all Compute Nodes that have run the Job Preparation or Job Release
        /// Task. This includes Compute Nodes which have since been removed
        /// from the Pool. If this API is invoked on a Job which has no Job
        /// Preparation or Job Release Task, the Batch service returns HTTP
        /// status code 409 (Conflict) with an error code of
        /// JobPreparationTaskNotSpecified.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job.
        /// </param>
        /// <param name='jobListPreparationAndReleaseTaskStatusOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<JobPreparationAndReleaseTaskExecutionInformation>,JobListPreparationAndReleaseTaskStatusHeaders>> ListPreparationAndReleaseTaskStatusWithHttpMessagesAsync(string jobId, JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions = default(JobListPreparationAndReleaseTaskStatusOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Gets the Task counts for the specified Job.
        /// </summary>
        /// <remarks>
        /// Task counts provide a count of the Tasks by active, running or
        /// completed Task state, and a count of Tasks which succeeded or
        /// failed. Tasks in the preparing state are counted as running. Note
        /// that the numbers returned may not always be up to date. If you need
        /// exact task counts, use a list query.
        /// </remarks>
        /// <param name='jobId'>
        /// The ID of the Job.
        /// </param>
        /// <param name='jobGetTaskCountsOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<TaskCountsResult,JobGetTaskCountsHeaders>> GetTaskCountsWithHttpMessagesAsync(string jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions = default(JobGetTaskCountsOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists all of the Jobs in the specified Account.
        /// </summary>
        /// <param name='nextPageLink'>
        /// The NextLink from the previous successful call to List operation.
        /// </param>
        /// <param name='jobListNextOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<CloudJob>,JobListHeaders>> ListNextWithHttpMessagesAsync(string nextPageLink, JobListNextOptions jobListNextOptions = default(JobListNextOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Jobs that have been created under the specified Job
        /// Schedule.
        /// </summary>
        /// <param name='nextPageLink'>
        /// The NextLink from the previous successful call to List operation.
        /// </param>
        /// <param name='jobListFromJobScheduleNextOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<CloudJob>,JobListFromJobScheduleHeaders>> ListFromJobScheduleNextWithHttpMessagesAsync(string nextPageLink, JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = default(JobListFromJobScheduleNextOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the execution status of the Job Preparation and Job Release
        /// Task for the specified Job across the Compute Nodes where the Job
        /// has run.
        /// </summary>
        /// <remarks>
        /// This API returns the Job Preparation and Job Release Task status on
        /// all Compute Nodes that have run the Job Preparation or Job Release
        /// Task. This includes Compute Nodes which have since been removed
        /// from the Pool. If this API is invoked on a Job which has no Job
        /// Preparation or Job Release Task, the Batch service returns HTTP
        /// status code 409 (Conflict) with an error code of
        /// JobPreparationTaskNotSpecified.
        /// </remarks>
        /// <param name='nextPageLink'>
        /// The NextLink from the previous successful call to List operation.
        /// </param>
        /// <param name='jobListPreparationAndReleaseTaskStatusNextOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<JobPreparationAndReleaseTaskExecutionInformation>,JobListPreparationAndReleaseTaskStatusHeaders>> ListPreparationAndReleaseTaskStatusNextWithHttpMessagesAsync(string nextPageLink, JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = default(JobListPreparationAndReleaseTaskStatusNextOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
    }
}
