// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// ComputeNodeOperations operations.
    /// </summary>
    public partial interface IComputeNodeOperations
    {
        /// <summary>
        /// Adds a user Account to the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can add a user Account to a Compute Node only when it is in the
        /// idle or running state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the machine on which you want to create a user Account.
        /// </param>
        /// <param name='user'>
        /// The user Account to be created.
        /// </param>
        /// <param name='computeNodeAddUserOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeAddUserHeaders>> AddUserWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions = default(ComputeNodeAddUserOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Deletes a user Account from the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can delete a user Account to a Compute Node only when it is in
        /// the idle or running state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the machine on which you want to delete a user Account.
        /// </param>
        /// <param name='userName'>
        /// The name of the user Account to delete.
        /// </param>
        /// <param name='computeNodeDeleteUserOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeDeleteUserHeaders>> DeleteUserWithHttpMessagesAsync(string poolId, string nodeId, string userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions = default(ComputeNodeDeleteUserOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Updates the password and expiration time of a user Account on the
        /// specified Compute Node.
        /// </summary>
        /// <remarks>
        /// This operation replaces of all the updatable properties of the
        /// Account. For example, if the expiryTime element is not specified,
        /// the current value is replaced with the default value, not left
        /// unmodified. You can update a user Account on a Compute Node only
        /// when it is in the idle or running state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the machine on which you want to update a user Account.
        /// </param>
        /// <param name='userName'>
        /// The name of the user Account to update.
        /// </param>
        /// <param name='nodeUpdateUserParameter'>
        /// The parameters for the request.
        /// </param>
        /// <param name='computeNodeUpdateUserOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeUpdateUserHeaders>> UpdateUserWithHttpMessagesAsync(string poolId, string nodeId, string userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions = default(ComputeNodeUpdateUserOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Gets information about the specified Compute Node.
        /// </summary>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to get information about.
        /// </param>
        /// <param name='computeNodeGetOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<ComputeNode,ComputeNodeGetHeaders>> GetWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeGetOptions computeNodeGetOptions = default(ComputeNodeGetOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Restarts the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can restart a Compute Node only if it is in an idle or running
        /// state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to restart.
        /// </param>
        /// <param name='nodeRebootOption'>
        /// When to reboot the Compute Node and what to do with currently
        /// running Tasks. The default value is requeue. Possible values
        /// include: 'requeue', 'terminate', 'taskCompletion', 'retainedData'
        /// </param>
        /// <param name='computeNodeRebootOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeRebootHeaders>> RebootWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeRebootOption? nodeRebootOption = default(ComputeNodeRebootOption?), ComputeNodeRebootOptions computeNodeRebootOptions = default(ComputeNodeRebootOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Reinstalls the operating system on the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can reinstall the operating system on a Compute Node only if it
        /// is in an idle or running state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to restart.
        /// </param>
        /// <param name='nodeReimageOption'>
        /// When to reimage the Compute Node and what to do with currently
        /// running Tasks. The default value is requeue. Possible values
        /// include: 'requeue', 'terminate', 'taskCompletion', 'retainedData'
        /// </param>
        /// <param name='computeNodeReimageOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeReimageHeaders>> ReimageWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeReimageOption? nodeReimageOption = default(ComputeNodeReimageOption?), ComputeNodeReimageOptions computeNodeReimageOptions = default(ComputeNodeReimageOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Disables Task scheduling on the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can disable Task scheduling on a Compute Node only if its
        /// current scheduling state is enabled.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node on which you want to disable Task
        /// scheduling.
        /// </param>
        /// <param name='nodeDisableSchedulingOption'>
        /// What to do with currently running Tasks when disabling Task
        /// scheduling on the Compute Node. The default value is requeue.
        /// Possible values include: 'requeue', 'terminate', 'taskCompletion'
        /// </param>
        /// <param name='computeNodeDisableSchedulingOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeDisableSchedulingHeaders>> DisableSchedulingWithHttpMessagesAsync(string poolId, string nodeId, DisableComputeNodeSchedulingOption? nodeDisableSchedulingOption = default(DisableComputeNodeSchedulingOption?), ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions = default(ComputeNodeDisableSchedulingOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Enables Task scheduling on the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can enable Task scheduling on a Compute Node only if its
        /// current scheduling state is disabled
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node on which you want to enable Task
        /// scheduling.
        /// </param>
        /// <param name='computeNodeEnableSchedulingOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeEnableSchedulingHeaders>> EnableSchedulingWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions = default(ComputeNodeEnableSchedulingOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Starts the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can start a Compute Node only if it has been deallocated
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to start.
        /// </param>
        /// <param name='computeNodeStartOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeStartHeaders>> StartWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeStartOptions computeNodeStartOptions = default(ComputeNodeStartOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Deallocates the specified Compute Node.
        /// </summary>
        /// <remarks>
        /// You can deallocate a Compute Node only if it is in an idle or
        /// running state.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to deallocate.
        /// </param>
        /// <param name='nodeDeallocateOption'>
        /// When to deallocate the Compute Node and what to do with currently
        /// running Tasks. The default value is requeue. Possible values
        /// include: 'requeue', 'terminate', 'taskCompletion', 'retainedData'
        /// </param>
        /// <param name='computeNodeDeallocateOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationHeaderResponse<ComputeNodeDeallocateHeaders>> DeallocateWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeDeallocateOption? nodeDeallocateOption = default(ComputeNodeDeallocateOption?), ComputeNodeDeallocateOptions computeNodeDeallocateOptions = default(ComputeNodeDeallocateOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Gets the settings required for remote login to a Compute Node.
        /// </summary>
        /// <remarks>
        /// Before you can remotely login to a Compute Node using the remote
        /// login settings, you must create a user Account on the Compute Node.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node for which to obtain the remote login
        /// settings.
        /// </param>
        /// <param name='computeNodeGetRemoteLoginSettingsOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<ComputeNodeGetRemoteLoginSettingsResult,ComputeNodeGetRemoteLoginSettingsHeaders>> GetRemoteLoginSettingsWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions = default(ComputeNodeGetRemoteLoginSettingsOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Upload Azure Batch service log files from the specified Compute
        /// Node to Azure Blob Storage.
        /// </summary>
        /// <remarks>
        /// This is for gathering Azure Batch service log files in an automated
        /// fashion from Compute Nodes if you are experiencing an error and
        /// wish to escalate to Azure support. The Azure Batch service log
        /// files should be shared with Azure support to aid in debugging
        /// issues with the Batch service.
        /// </remarks>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node from which you want to upload the Azure
        /// Batch service log files.
        /// </param>
        /// <param name='uploadBatchServiceLogsConfiguration'>
        /// The Azure Batch service log files upload configuration.
        /// </param>
        /// <param name='computeNodeUploadBatchServiceLogsOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<UploadBatchServiceLogsResult,ComputeNodeUploadBatchServiceLogsHeaders>> UploadBatchServiceLogsWithHttpMessagesAsync(string poolId, string nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions = default(ComputeNodeUploadBatchServiceLogsOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Compute Nodes in the specified Pool.
        /// </summary>
        /// <param name='poolId'>
        /// The ID of the Pool from which you want to list Compute Nodes.
        /// </param>
        /// <param name='computeNodeListOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<ComputeNode>,ComputeNodeListHeaders>> ListWithHttpMessagesAsync(string poolId, ComputeNodeListOptions computeNodeListOptions = default(ComputeNodeListOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Compute Nodes in the specified Pool.
        /// </summary>
        /// <param name='nextPageLink'>
        /// The NextLink from the previous successful call to List operation.
        /// </param>
        /// <param name='computeNodeListNextOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<ComputeNode>,ComputeNodeListHeaders>> ListNextWithHttpMessagesAsync(string nextPageLink, ComputeNodeListNextOptions computeNodeListNextOptions = default(ComputeNodeListNextOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
    }
}
