// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// ComputeNodeExtensionOperations operations.
    /// </summary>
    public partial interface IComputeNodeExtensionOperations
    {
        /// <summary>
        /// Gets information about the specified Compute Node Extension.
        /// </summary>
        /// <param name='poolId'>
        /// The ID of the Pool that contains the Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that contains the extensions.
        /// </param>
        /// <param name='extensionName'>
        /// The name of the of the Compute Node Extension that you want to get
        /// information about.
        /// </param>
        /// <param name='computeNodeExtensionGetOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<NodeVMExtension,ComputeNodeExtensionGetHeaders>> GetWithHttpMessagesAsync(string poolId, string nodeId, string extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions = default(ComputeNodeExtensionGetOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Compute Nodes Extensions in the specified Pool.
        /// </summary>
        /// <param name='poolId'>
        /// The ID of the Pool that contains Compute Node.
        /// </param>
        /// <param name='nodeId'>
        /// The ID of the Compute Node that you want to list extensions.
        /// </param>
        /// <param name='computeNodeExtensionListOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<NodeVMExtension>,ComputeNodeExtensionListHeaders>> ListWithHttpMessagesAsync(string poolId, string nodeId, ComputeNodeExtensionListOptions computeNodeExtensionListOptions = default(ComputeNodeExtensionListOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
        /// <summary>
        /// Lists the Compute Nodes Extensions in the specified Pool.
        /// </summary>
        /// <param name='nextPageLink'>
        /// The NextLink from the previous successful call to List operation.
        /// </param>
        /// <param name='computeNodeExtensionListNextOptions'>
        /// Additional parameters for the operation
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="BatchErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="Microsoft.Rest.SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="Microsoft.Rest.ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        Task<AzureOperationResponse<IPage<NodeVMExtension>,ComputeNodeExtensionListHeaders>> ListNextWithHttpMessagesAsync(string nextPageLink, ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = default(ComputeNodeExtensionListNextOptions), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));
    }
}
