// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ComputeNodeOperations.
    /// </summary>
    public static partial class ComputeNodeOperationsExtensions
    {
            /// <summary>
            /// Adds a user Account to the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can add a user Account to a Compute Node only when it is in the idle or
            /// running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to create a user Account.
            /// </param>
            /// <param name='user'>
            /// The user Account to be created.
            /// </param>
            /// <param name='computeNodeAddUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeAddUserHeaders AddUser(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions = default(ComputeNodeAddUserOptions))
            {
                return operations.AddUserAsync(poolId, nodeId, user, computeNodeAddUserOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Adds a user Account to the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can add a user Account to a Compute Node only when it is in the idle or
            /// running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to create a user Account.
            /// </param>
            /// <param name='user'>
            /// The user Account to be created.
            /// </param>
            /// <param name='computeNodeAddUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeAddUserHeaders> AddUserAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions = default(ComputeNodeAddUserOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddUserWithHttpMessagesAsync(poolId, nodeId, user, computeNodeAddUserOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Deletes a user Account from the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can delete a user Account to a Compute Node only when it is in the idle
            /// or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to delete a user Account.
            /// </param>
            /// <param name='userName'>
            /// The name of the user Account to delete.
            /// </param>
            /// <param name='computeNodeDeleteUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeDeleteUserHeaders DeleteUser(this IComputeNodeOperations operations, string poolId, string nodeId, string userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions = default(ComputeNodeDeleteUserOptions))
            {
                return operations.DeleteUserAsync(poolId, nodeId, userName, computeNodeDeleteUserOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes a user Account from the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can delete a user Account to a Compute Node only when it is in the idle
            /// or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to delete a user Account.
            /// </param>
            /// <param name='userName'>
            /// The name of the user Account to delete.
            /// </param>
            /// <param name='computeNodeDeleteUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeDeleteUserHeaders> DeleteUserAsync(this IComputeNodeOperations operations, string poolId, string nodeId, string userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions = default(ComputeNodeDeleteUserOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteUserWithHttpMessagesAsync(poolId, nodeId, userName, computeNodeDeleteUserOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Updates the password and expiration time of a user Account on the specified
            /// Compute Node.
            /// </summary>
            /// <remarks>
            /// This operation replaces of all the updatable properties of the Account. For
            /// example, if the expiryTime element is not specified, the current value is
            /// replaced with the default value, not left unmodified. You can update a user
            /// Account on a Compute Node only when it is in the idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to update a user Account.
            /// </param>
            /// <param name='userName'>
            /// The name of the user Account to update.
            /// </param>
            /// <param name='nodeUpdateUserParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='computeNodeUpdateUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeUpdateUserHeaders UpdateUser(this IComputeNodeOperations operations, string poolId, string nodeId, string userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions = default(ComputeNodeUpdateUserOptions))
            {
                return operations.UpdateUserAsync(poolId, nodeId, userName, nodeUpdateUserParameter, computeNodeUpdateUserOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates the password and expiration time of a user Account on the specified
            /// Compute Node.
            /// </summary>
            /// <remarks>
            /// This operation replaces of all the updatable properties of the Account. For
            /// example, if the expiryTime element is not specified, the current value is
            /// replaced with the default value, not left unmodified. You can update a user
            /// Account on a Compute Node only when it is in the idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the machine on which you want to update a user Account.
            /// </param>
            /// <param name='userName'>
            /// The name of the user Account to update.
            /// </param>
            /// <param name='nodeUpdateUserParameter'>
            /// The parameters for the request.
            /// </param>
            /// <param name='computeNodeUpdateUserOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeUpdateUserHeaders> UpdateUserAsync(this IComputeNodeOperations operations, string poolId, string nodeId, string userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions = default(ComputeNodeUpdateUserOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateUserWithHttpMessagesAsync(poolId, nodeId, userName, nodeUpdateUserParameter, computeNodeUpdateUserOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets information about the specified Compute Node.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to get information about.
            /// </param>
            /// <param name='computeNodeGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNode Get(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeGetOptions computeNodeGetOptions = default(ComputeNodeGetOptions))
            {
                return operations.GetAsync(poolId, nodeId, computeNodeGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Compute Node.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to get information about.
            /// </param>
            /// <param name='computeNodeGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNode> GetAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeGetOptions computeNodeGetOptions = default(ComputeNodeGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(poolId, nodeId, computeNodeGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Restarts the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can restart a Compute Node only if it is in an idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to restart.
            /// </param>
            /// <param name='nodeRebootOption'>
            /// When to reboot the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeRebootOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeRebootHeaders Reboot(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeRebootOption? nodeRebootOption = default(ComputeNodeRebootOption?), ComputeNodeRebootOptions computeNodeRebootOptions = default(ComputeNodeRebootOptions))
            {
                return operations.RebootAsync(poolId, nodeId, nodeRebootOption, computeNodeRebootOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Restarts the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can restart a Compute Node only if it is in an idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to restart.
            /// </param>
            /// <param name='nodeRebootOption'>
            /// When to reboot the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeRebootOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeRebootHeaders> RebootAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeRebootOption? nodeRebootOption = default(ComputeNodeRebootOption?), ComputeNodeRebootOptions computeNodeRebootOptions = default(ComputeNodeRebootOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.RebootWithHttpMessagesAsync(poolId, nodeId, nodeRebootOption, computeNodeRebootOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Reinstalls the operating system on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can reinstall the operating system on a Compute Node only if it is in
            /// an idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to restart.
            /// </param>
            /// <param name='nodeReimageOption'>
            /// When to reimage the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeReimageOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeReimageHeaders Reimage(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeReimageOption? nodeReimageOption = default(ComputeNodeReimageOption?), ComputeNodeReimageOptions computeNodeReimageOptions = default(ComputeNodeReimageOptions))
            {
                return operations.ReimageAsync(poolId, nodeId, nodeReimageOption, computeNodeReimageOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Reinstalls the operating system on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can reinstall the operating system on a Compute Node only if it is in
            /// an idle or running state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to restart.
            /// </param>
            /// <param name='nodeReimageOption'>
            /// When to reimage the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeReimageOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeReimageHeaders> ReimageAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeReimageOption? nodeReimageOption = default(ComputeNodeReimageOption?), ComputeNodeReimageOptions computeNodeReimageOptions = default(ComputeNodeReimageOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ReimageWithHttpMessagesAsync(poolId, nodeId, nodeReimageOption, computeNodeReimageOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Disables Task scheduling on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can disable Task scheduling on a Compute Node only if its current
            /// scheduling state is enabled.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node on which you want to disable Task scheduling.
            /// </param>
            /// <param name='nodeDisableSchedulingOption'>
            /// What to do with currently running Tasks when disabling Task scheduling on
            /// the Compute Node. The default value is requeue. Possible values include:
            /// 'requeue', 'terminate', 'taskCompletion'
            /// </param>
            /// <param name='computeNodeDisableSchedulingOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeDisableSchedulingHeaders DisableScheduling(this IComputeNodeOperations operations, string poolId, string nodeId, DisableComputeNodeSchedulingOption? nodeDisableSchedulingOption = default(DisableComputeNodeSchedulingOption?), ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions = default(ComputeNodeDisableSchedulingOptions))
            {
                return operations.DisableSchedulingAsync(poolId, nodeId, nodeDisableSchedulingOption, computeNodeDisableSchedulingOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Disables Task scheduling on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can disable Task scheduling on a Compute Node only if its current
            /// scheduling state is enabled.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node on which you want to disable Task scheduling.
            /// </param>
            /// <param name='nodeDisableSchedulingOption'>
            /// What to do with currently running Tasks when disabling Task scheduling on
            /// the Compute Node. The default value is requeue. Possible values include:
            /// 'requeue', 'terminate', 'taskCompletion'
            /// </param>
            /// <param name='computeNodeDisableSchedulingOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeDisableSchedulingHeaders> DisableSchedulingAsync(this IComputeNodeOperations operations, string poolId, string nodeId, DisableComputeNodeSchedulingOption? nodeDisableSchedulingOption = default(DisableComputeNodeSchedulingOption?), ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions = default(ComputeNodeDisableSchedulingOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DisableSchedulingWithHttpMessagesAsync(poolId, nodeId, nodeDisableSchedulingOption, computeNodeDisableSchedulingOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Enables Task scheduling on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can enable Task scheduling on a Compute Node only if its current
            /// scheduling state is disabled
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node on which you want to enable Task scheduling.
            /// </param>
            /// <param name='computeNodeEnableSchedulingOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeEnableSchedulingHeaders EnableScheduling(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions = default(ComputeNodeEnableSchedulingOptions))
            {
                return operations.EnableSchedulingAsync(poolId, nodeId, computeNodeEnableSchedulingOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Enables Task scheduling on the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can enable Task scheduling on a Compute Node only if its current
            /// scheduling state is disabled
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node on which you want to enable Task scheduling.
            /// </param>
            /// <param name='computeNodeEnableSchedulingOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeEnableSchedulingHeaders> EnableSchedulingAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions = default(ComputeNodeEnableSchedulingOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EnableSchedulingWithHttpMessagesAsync(poolId, nodeId, computeNodeEnableSchedulingOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Starts the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can start a Compute Node only if it has been deallocated
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to start.
            /// </param>
            /// <param name='computeNodeStartOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeStartHeaders Start(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeStartOptions computeNodeStartOptions = default(ComputeNodeStartOptions))
            {
                return operations.StartAsync(poolId, nodeId, computeNodeStartOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Starts the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can start a Compute Node only if it has been deallocated
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to start.
            /// </param>
            /// <param name='computeNodeStartOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeStartHeaders> StartAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeStartOptions computeNodeStartOptions = default(ComputeNodeStartOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.StartWithHttpMessagesAsync(poolId, nodeId, computeNodeStartOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Deallocates the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can deallocate a Compute Node only if it is in an idle or running
            /// state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to deallocate.
            /// </param>
            /// <param name='nodeDeallocateOption'>
            /// When to deallocate the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeDeallocateOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeDeallocateHeaders Deallocate(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeDeallocateOption? nodeDeallocateOption = default(ComputeNodeDeallocateOption?), ComputeNodeDeallocateOptions computeNodeDeallocateOptions = default(ComputeNodeDeallocateOptions))
            {
                return operations.DeallocateAsync(poolId, nodeId, nodeDeallocateOption, computeNodeDeallocateOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deallocates the specified Compute Node.
            /// </summary>
            /// <remarks>
            /// You can deallocate a Compute Node only if it is in an idle or running
            /// state.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to deallocate.
            /// </param>
            /// <param name='nodeDeallocateOption'>
            /// When to deallocate the Compute Node and what to do with currently running
            /// Tasks. The default value is requeue. Possible values include: 'requeue',
            /// 'terminate', 'taskCompletion', 'retainedData'
            /// </param>
            /// <param name='computeNodeDeallocateOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeDeallocateHeaders> DeallocateAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeDeallocateOption? nodeDeallocateOption = default(ComputeNodeDeallocateOption?), ComputeNodeDeallocateOptions computeNodeDeallocateOptions = default(ComputeNodeDeallocateOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeallocateWithHttpMessagesAsync(poolId, nodeId, nodeDeallocateOption, computeNodeDeallocateOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Gets the settings required for remote login to a Compute Node.
            /// </summary>
            /// <remarks>
            /// Before you can remotely login to a Compute Node using the remote login
            /// settings, you must create a user Account on the Compute Node.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node for which to obtain the remote login settings.
            /// </param>
            /// <param name='computeNodeGetRemoteLoginSettingsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ComputeNodeGetRemoteLoginSettingsResult GetRemoteLoginSettings(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions = default(ComputeNodeGetRemoteLoginSettingsOptions))
            {
                return operations.GetRemoteLoginSettingsAsync(poolId, nodeId, computeNodeGetRemoteLoginSettingsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the settings required for remote login to a Compute Node.
            /// </summary>
            /// <remarks>
            /// Before you can remotely login to a Compute Node using the remote login
            /// settings, you must create a user Account on the Compute Node.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node for which to obtain the remote login settings.
            /// </param>
            /// <param name='computeNodeGetRemoteLoginSettingsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ComputeNodeGetRemoteLoginSettingsResult> GetRemoteLoginSettingsAsync(this IComputeNodeOperations operations, string poolId, string nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions = default(ComputeNodeGetRemoteLoginSettingsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetRemoteLoginSettingsWithHttpMessagesAsync(poolId, nodeId, computeNodeGetRemoteLoginSettingsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Upload Azure Batch service log files from the specified Compute Node to
            /// Azure Blob Storage.
            /// </summary>
            /// <remarks>
            /// This is for gathering Azure Batch service log files in an automated fashion
            /// from Compute Nodes if you are experiencing an error and wish to escalate to
            /// Azure support. The Azure Batch service log files should be shared with
            /// Azure support to aid in debugging issues with the Batch service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node from which you want to upload the Azure Batch
            /// service log files.
            /// </param>
            /// <param name='uploadBatchServiceLogsConfiguration'>
            /// The Azure Batch service log files upload configuration.
            /// </param>
            /// <param name='computeNodeUploadBatchServiceLogsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static UploadBatchServiceLogsResult UploadBatchServiceLogs(this IComputeNodeOperations operations, string poolId, string nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions = default(ComputeNodeUploadBatchServiceLogsOptions))
            {
                return operations.UploadBatchServiceLogsAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration, computeNodeUploadBatchServiceLogsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Upload Azure Batch service log files from the specified Compute Node to
            /// Azure Blob Storage.
            /// </summary>
            /// <remarks>
            /// This is for gathering Azure Batch service log files in an automated fashion
            /// from Compute Nodes if you are experiencing an error and wish to escalate to
            /// Azure support. The Azure Batch service log files should be shared with
            /// Azure support to aid in debugging issues with the Batch service.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node from which you want to upload the Azure Batch
            /// service log files.
            /// </param>
            /// <param name='uploadBatchServiceLogsConfiguration'>
            /// The Azure Batch service log files upload configuration.
            /// </param>
            /// <param name='computeNodeUploadBatchServiceLogsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<UploadBatchServiceLogsResult> UploadBatchServiceLogsAsync(this IComputeNodeOperations operations, string poolId, string nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions = default(ComputeNodeUploadBatchServiceLogsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UploadBatchServiceLogsWithHttpMessagesAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration, computeNodeUploadBatchServiceLogsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Compute Nodes in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool from which you want to list Compute Nodes.
            /// </param>
            /// <param name='computeNodeListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ComputeNode> List(this IComputeNodeOperations operations, string poolId, ComputeNodeListOptions computeNodeListOptions = default(ComputeNodeListOptions))
            {
                return operations.ListAsync(poolId, computeNodeListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Compute Nodes in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool from which you want to list Compute Nodes.
            /// </param>
            /// <param name='computeNodeListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ComputeNode>> ListAsync(this IComputeNodeOperations operations, string poolId, ComputeNodeListOptions computeNodeListOptions = default(ComputeNodeListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(poolId, computeNodeListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Compute Nodes in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='computeNodeListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ComputeNode> ListNext(this IComputeNodeOperations operations, string nextPageLink, ComputeNodeListNextOptions computeNodeListNextOptions = default(ComputeNodeListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, computeNodeListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Compute Nodes in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='computeNodeListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ComputeNode>> ListNextAsync(this IComputeNodeOperations operations, string nextPageLink, ComputeNodeListNextOptions computeNodeListNextOptions = default(ComputeNodeListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, computeNodeListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
