// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ComputeNodeExtensionOperations.
    /// </summary>
    public static partial class ComputeNodeExtensionOperationsExtensions
    {
            /// <summary>
            /// Gets information about the specified Compute Node Extension.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that contains the extensions.
            /// </param>
            /// <param name='extensionName'>
            /// The name of the of the Compute Node Extension that you want to get
            /// information about.
            /// </param>
            /// <param name='computeNodeExtensionGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static NodeVMExtension Get(this IComputeNodeExtensionOperations operations, string poolId, string nodeId, string extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions = default(ComputeNodeExtensionGetOptions))
            {
                return operations.GetAsync(poolId, nodeId, extensionName, computeNodeExtensionGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Compute Node Extension.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains the Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that contains the extensions.
            /// </param>
            /// <param name='extensionName'>
            /// The name of the of the Compute Node Extension that you want to get
            /// information about.
            /// </param>
            /// <param name='computeNodeExtensionGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<NodeVMExtension> GetAsync(this IComputeNodeExtensionOperations operations, string poolId, string nodeId, string extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions = default(ComputeNodeExtensionGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(poolId, nodeId, extensionName, computeNodeExtensionGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Compute Nodes Extensions in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to list extensions.
            /// </param>
            /// <param name='computeNodeExtensionListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<NodeVMExtension> List(this IComputeNodeExtensionOperations operations, string poolId, string nodeId, ComputeNodeExtensionListOptions computeNodeExtensionListOptions = default(ComputeNodeExtensionListOptions))
            {
                return operations.ListAsync(poolId, nodeId, computeNodeExtensionListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Compute Nodes Extensions in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='poolId'>
            /// The ID of the Pool that contains Compute Node.
            /// </param>
            /// <param name='nodeId'>
            /// The ID of the Compute Node that you want to list extensions.
            /// </param>
            /// <param name='computeNodeExtensionListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<NodeVMExtension>> ListAsync(this IComputeNodeExtensionOperations operations, string poolId, string nodeId, ComputeNodeExtensionListOptions computeNodeExtensionListOptions = default(ComputeNodeExtensionListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(poolId, nodeId, computeNodeExtensionListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists the Compute Nodes Extensions in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='computeNodeExtensionListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<NodeVMExtension> ListNext(this IComputeNodeExtensionOperations operations, string nextPageLink, ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = default(ComputeNodeExtensionListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, computeNodeExtensionListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists the Compute Nodes Extensions in the specified Pool.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='computeNodeExtensionListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<NodeVMExtension>> ListNextAsync(this IComputeNodeExtensionOperations operations, string nextPageLink, ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = default(ComputeNodeExtensionListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, computeNodeExtensionListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
