// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ApplicationOperations.
    /// </summary>
    public static partial class ApplicationOperationsExtensions
    {
            /// <summary>
            /// Lists all of the applications available in the specified Account.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='applicationListOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ApplicationSummary> List(this IApplicationOperations operations, ApplicationListOptions applicationListOptions = default(ApplicationListOptions))
            {
                return operations.ListAsync(applicationListOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the applications available in the specified Account.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='applicationListOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ApplicationSummary>> ListAsync(this IApplicationOperations operations, ApplicationListOptions applicationListOptions = default(ApplicationListOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(applicationListOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets information about the specified Application.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about Applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='applicationId'>
            /// The ID of the Application.
            /// </param>
            /// <param name='applicationGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static ApplicationSummary Get(this IApplicationOperations operations, string applicationId, ApplicationGetOptions applicationGetOptions = default(ApplicationGetOptions))
            {
                return operations.GetAsync(applicationId, applicationGetOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets information about the specified Application.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about Applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='applicationId'>
            /// The ID of the Application.
            /// </param>
            /// <param name='applicationGetOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ApplicationSummary> GetAsync(this IApplicationOperations operations, string applicationId, ApplicationGetOptions applicationGetOptions = default(ApplicationGetOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(applicationId, applicationGetOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists all of the applications available in the specified Account.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='applicationListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ApplicationSummary> ListNext(this IApplicationOperations operations, string nextPageLink, ApplicationListNextOptions applicationListNextOptions = default(ApplicationListNextOptions))
            {
                return operations.ListNextAsync(nextPageLink, applicationListNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all of the applications available in the specified Account.
            /// </summary>
            /// <remarks>
            /// This operation returns only Applications and versions that are available
            /// for use on Compute Nodes; that is, that can be used in an Package
            /// reference. For administrator information about applications and versions
            /// that are not yet available to Compute Nodes, use the Azure portal or the
            /// Azure Resource Manager API.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='applicationListNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ApplicationSummary>> ListNextAsync(this IApplicationOperations operations, string nextPageLink, ApplicationListNextOptions applicationListNextOptions = default(ApplicationListNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListNextWithHttpMessagesAsync(nextPageLink, applicationListNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
