// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.Batch.Protocol
{
    using Microsoft.Rest;
    using Microsoft.Rest.Azure;
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for AccountOperations.
    /// </summary>
    public static partial class AccountOperationsExtensions
    {
            /// <summary>
            /// Lists all Virtual Machine Images supported by the Azure Batch service.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='accountListSupportedImagesOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ImageInformation> ListSupportedImages(this IAccountOperations operations, AccountListSupportedImagesOptions accountListSupportedImagesOptions = default(AccountListSupportedImagesOptions))
            {
                return operations.ListSupportedImagesAsync(accountListSupportedImagesOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all Virtual Machine Images supported by the Azure Batch service.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='accountListSupportedImagesOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ImageInformation>> ListSupportedImagesAsync(this IAccountOperations operations, AccountListSupportedImagesOptions accountListSupportedImagesOptions = default(AccountListSupportedImagesOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListSupportedImagesWithHttpMessagesAsync(accountListSupportedImagesOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that
            /// the numbers returned may not always be up to date. If you need exact node
            /// counts, use a list query.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='accountListPoolNodeCountsOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<PoolNodeCounts> ListPoolNodeCounts(this IAccountOperations operations, AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions = default(AccountListPoolNodeCountsOptions))
            {
                return operations.ListPoolNodeCountsAsync(accountListPoolNodeCountsOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that
            /// the numbers returned may not always be up to date. If you need exact node
            /// counts, use a list query.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='accountListPoolNodeCountsOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<PoolNodeCounts>> ListPoolNodeCountsAsync(this IAccountOperations operations, AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions = default(AccountListPoolNodeCountsOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPoolNodeCountsWithHttpMessagesAsync(accountListPoolNodeCountsOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Lists all Virtual Machine Images supported by the Azure Batch service.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='accountListSupportedImagesNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<ImageInformation> ListSupportedImagesNext(this IAccountOperations operations, string nextPageLink, AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions = default(AccountListSupportedImagesNextOptions))
            {
                return operations.ListSupportedImagesNextAsync(nextPageLink, accountListSupportedImagesNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Lists all Virtual Machine Images supported by the Azure Batch service.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='accountListSupportedImagesNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<ImageInformation>> ListSupportedImagesNextAsync(this IAccountOperations operations, string nextPageLink, AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions = default(AccountListSupportedImagesNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListSupportedImagesNextWithHttpMessagesAsync(nextPageLink, accountListSupportedImagesNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that
            /// the numbers returned may not always be up to date. If you need exact node
            /// counts, use a list query.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='accountListPoolNodeCountsNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            public static IPage<PoolNodeCounts> ListPoolNodeCountsNext(this IAccountOperations operations, string nextPageLink, AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions = default(AccountListPoolNodeCountsNextOptions))
            {
                return operations.ListPoolNodeCountsNextAsync(nextPageLink, accountListPoolNodeCountsNextOptions).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that
            /// the numbers returned may not always be up to date. If you need exact node
            /// counts, use a list query.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='nextPageLink'>
            /// The NextLink from the previous successful call to List operation.
            /// </param>
            /// <param name='accountListPoolNodeCountsNextOptions'>
            /// Additional parameters for the operation
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IPage<PoolNodeCounts>> ListPoolNodeCountsNextAsync(this IAccountOperations operations, string nextPageLink, AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions = default(AccountListPoolNodeCountsNextOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListPoolNodeCountsNextWithHttpMessagesAsync(nextPageLink, accountListPoolNodeCountsNextOptions, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
