// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Properties used to create a user account on a Windows node.
    /// </summary>
    public partial class WindowsUserConfiguration : ITransportObjectProvider<Models.WindowsUserConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<Common.LoginMode?> LoginModeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.LoginModeProperty = this.CreatePropertyAccessor<Common.LoginMode?>(nameof(LoginMode), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.WindowsUserConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.LoginModeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.LoginMode, Common.LoginMode>(protocolObject.LoginMode),
                    nameof(LoginMode),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="WindowsUserConfiguration"/> class.
        /// </summary>
        /// <param name='loginMode'>The login mode for the user.</param>
        public WindowsUserConfiguration(
            Common.LoginMode? loginMode = default(Common.LoginMode?))
        {
            this.propertyContainer = new PropertyContainer();
            this.LoginMode = loginMode;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="WindowsUserConfiguration"/> class.
        /// </summary>
        protected WindowsUserConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal WindowsUserConfiguration(Models.WindowsUserConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region WindowsUserConfiguration

        /// <summary>
        /// Gets or sets the login mode for the user.
        /// </summary>
        /// <remarks>
        /// The default is 'batch'.
        /// </remarks>
        public Common.LoginMode? LoginMode
        {
            get { return this.propertyContainer.LoginModeProperty.Value; }
            set { this.propertyContainer.LoginModeProperty.Value = value; }
        }

        #endregion // WindowsUserConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.WindowsUserConfiguration ITransportObjectProvider<Models.WindowsUserConfiguration>.GetTransportObject()
        {
            Models.WindowsUserConfiguration result = new Models.WindowsUserConfiguration()
            {
                LoginMode = UtilitiesInternal.MapNullableEnum<Common.LoginMode, Models.LoginMode>(this.LoginMode),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}