// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Windows operating system settings to apply to the virtual machine.
    /// </summary>
    public partial class WindowsConfiguration : ITransportObjectProvider<Models.WindowsConfiguration>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="WindowsConfiguration"/> class.
        /// </summary>
        /// <param name='enableAutomaticUpdates'>Whether automatic updates are enabled on the virtual machine. If unspecified, the default value is true.</param>
        public WindowsConfiguration(
            bool? enableAutomaticUpdates = default(bool?))
        {
            this.EnableAutomaticUpdates = enableAutomaticUpdates;
        }

        internal WindowsConfiguration(Models.WindowsConfiguration protocolObject)
        {
            this.EnableAutomaticUpdates = protocolObject.EnableAutomaticUpdates;
        }

        #endregion Constructors

        #region WindowsConfiguration

        /// <summary>
        /// Gets whether automatic updates are enabled on the virtual machine. If unspecified, the default value is true.
        /// </summary>
        public bool? EnableAutomaticUpdates { get; }

        #endregion // WindowsConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.WindowsConfiguration ITransportObjectProvider<Models.WindowsConfiguration>.GetTransportObject()
        {
            Models.WindowsConfiguration result = new Models.WindowsConfiguration()
            {
                EnableAutomaticUpdates = this.EnableAutomaticUpdates,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}