// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Info about the current state of the virtual machine.
    /// </summary>
    public partial class VirtualMachineInfo : ITransportObjectProvider<Models.VirtualMachineInfo>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<ImageReference> ImageReferenceProperty;
            public readonly PropertyAccessor<string> ScaleSetVmResourceIdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.ImageReferenceProperty = this.CreatePropertyAccessor<ImageReference>(nameof(ImageReference), BindingAccess.Read | BindingAccess.Write);
                this.ScaleSetVmResourceIdProperty = this.CreatePropertyAccessor<string>(nameof(ScaleSetVmResourceId), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.VirtualMachineInfo protocolObject) : base(BindingState.Bound)
            {
                this.ImageReferenceProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ImageReference, o => new ImageReference(o).Freeze()),
                    nameof(ImageReference),
                    BindingAccess.Read);
                this.ScaleSetVmResourceIdProperty = this.CreatePropertyAccessor(
                    protocolObject.ScaleSetVmResourceId,
                    nameof(ScaleSetVmResourceId),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="VirtualMachineInfo"/> class.
        /// </summary>
        public VirtualMachineInfo()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal VirtualMachineInfo(Models.VirtualMachineInfo protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region VirtualMachineInfo

        /// <summary>
        /// Gets or sets the reference to the Azure Virtual Machine's Marketplace Image.
        /// </summary>
        public ImageReference ImageReference
        {
            get { return this.propertyContainer.ImageReferenceProperty.Value; }
            set { this.propertyContainer.ImageReferenceProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the resource ID of the Compute Node's current Virtual Machine Scale Set VM. Only defined if the 
        /// Batch Account was created with its poolAllocationMode property set to 'UserSubscription'.
        /// </summary>
        public string ScaleSetVmResourceId
        {
            get { return this.propertyContainer.ScaleSetVmResourceIdProperty.Value; }
            set { this.propertyContainer.ScaleSetVmResourceIdProperty.Value = value; }
        }

        #endregion // VirtualMachineInfo

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.VirtualMachineInfo ITransportObjectProvider<Models.VirtualMachineInfo>.GetTransportObject()
        {
            Models.VirtualMachineInfo result = new Models.VirtualMachineInfo()
            {
                ImageReference = UtilitiesInternal.CreateObjectWithNullCheck(this.ImageReference, (o) => o.GetTransportObject()),
                ScaleSetVmResourceId = this.ScaleSetVmResourceId,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<VirtualMachineInfo> ConvertFromProtocolCollection(IEnumerable<Models.VirtualMachineInfo> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<VirtualMachineInfo> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new VirtualMachineInfo(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<VirtualMachineInfo> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.VirtualMachineInfo> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<VirtualMachineInfo> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new VirtualMachineInfo(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<VirtualMachineInfo> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.VirtualMachineInfo> protoCollection)
        {
            IReadOnlyList<VirtualMachineInfo> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new VirtualMachineInfo(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}