// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The vm extension instance view.
    /// </summary>
    public partial class VMExtensionInstanceView : ITransportObjectProvider<Models.VMExtensionInstanceView>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> NameProperty;
            public readonly PropertyAccessor<IList<InstanceViewStatus>> StatusesProperty;
            public readonly PropertyAccessor<IList<InstanceViewStatus>> SubStatusesProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.NameProperty = this.CreatePropertyAccessor<string>(nameof(Name), BindingAccess.Read | BindingAccess.Write);
                this.StatusesProperty = this.CreatePropertyAccessor<IList<InstanceViewStatus>>(nameof(Statuses), BindingAccess.Read | BindingAccess.Write);
                this.SubStatusesProperty = this.CreatePropertyAccessor<IList<InstanceViewStatus>>(nameof(SubStatuses), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.VMExtensionInstanceView protocolObject) : base(BindingState.Bound)
            {
                this.NameProperty = this.CreatePropertyAccessor(
                    protocolObject.Name,
                    nameof(Name),
                    BindingAccess.Read);
                this.StatusesProperty = this.CreatePropertyAccessor(
                    InstanceViewStatus.ConvertFromProtocolCollectionAndFreeze(protocolObject.Statuses),
                    nameof(Statuses),
                    BindingAccess.Read);
                this.SubStatusesProperty = this.CreatePropertyAccessor(
                    InstanceViewStatus.ConvertFromProtocolCollectionAndFreeze(protocolObject.SubStatuses),
                    nameof(SubStatuses),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="VMExtensionInstanceView"/> class.
        /// </summary>
        public VMExtensionInstanceView()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal VMExtensionInstanceView(Models.VMExtensionInstanceView protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region VMExtensionInstanceView

        /// <summary>
        /// Gets or sets the name of the vm extension instance view.
        /// </summary>
        public string Name
        {
            get { return this.propertyContainer.NameProperty.Value; }
            set { this.propertyContainer.NameProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the resource status information.
        /// </summary>
        public IList<InstanceViewStatus> Statuses
        {
            get { return this.propertyContainer.StatusesProperty.Value; }
            set
            {
                this.propertyContainer.StatusesProperty.Value = ConcurrentChangeTrackedModifiableList<InstanceViewStatus>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        /// <summary>
        /// Gets or sets the resource substatus information.
        /// </summary>
        public IList<InstanceViewStatus> SubStatuses
        {
            get { return this.propertyContainer.SubStatusesProperty.Value; }
            set
            {
                this.propertyContainer.SubStatusesProperty.Value = ConcurrentChangeTrackedModifiableList<InstanceViewStatus>.TransformEnumerableToConcurrentModifiableList(value);
            }
        }

        #endregion // VMExtensionInstanceView

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.VMExtensionInstanceView ITransportObjectProvider<Models.VMExtensionInstanceView>.GetTransportObject()
        {
            Models.VMExtensionInstanceView result = new Models.VMExtensionInstanceView()
            {
                Name = this.Name,
                Statuses = UtilitiesInternal.ConvertToProtocolCollection(this.Statuses),
                SubStatuses = UtilitiesInternal.ConvertToProtocolCollection(this.SubStatuses),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}