// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the security profile settings for the managed disk. **Note**: It can only be set for Confidential VMs and 
    /// required when using Confidential VMs.
    /// </summary>
    public partial class VMDiskSecurityProfile : ITransportObjectProvider<Models.VMDiskSecurityProfile>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> SecurityEncryptionTypeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.SecurityEncryptionTypeProperty = this.CreatePropertyAccessor<string>(nameof(SecurityEncryptionType), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.VMDiskSecurityProfile protocolObject) : base(BindingState.Bound)
            {
                this.SecurityEncryptionTypeProperty = this.CreatePropertyAccessor(
                    protocolObject.SecurityEncryptionType,
                    nameof(SecurityEncryptionType),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="VMDiskSecurityProfile"/> class.
        /// </summary>
        public VMDiskSecurityProfile()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal VMDiskSecurityProfile(Models.VMDiskSecurityProfile protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region VMDiskSecurityProfile

        /// <summary>
        /// Gets or sets gets or sets specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for 
        /// encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState 
        /// blob. **Note**: It can be set for only Confidential VMs and is required when using Confidential VMs.
        /// </summary>
        /// <remarks>
        /// Possible values include: 'NonPersistedTPM', 'VMGuestStateOnly'
        /// </remarks>
        public string SecurityEncryptionType
        {
            get { return this.propertyContainer.SecurityEncryptionTypeProperty.Value; }
            set { this.propertyContainer.SecurityEncryptionTypeProperty.Value = value; }
        }

        #endregion // VMDiskSecurityProfile

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.VMDiskSecurityProfile ITransportObjectProvider<Models.VMDiskSecurityProfile>.GetTransportObject()
        {
            Models.VMDiskSecurityProfile result = new Models.VMDiskSecurityProfile()
            {
                SecurityEncryptionType = this.SecurityEncryptionType,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}