// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The definition of the user identity under which the task is run.
    /// </summary>
    public partial class UserIdentity : ITransportObjectProvider<Models.UserIdentity>, IPropertyMetadata
    {
        #region Constructors

        internal UserIdentity(Models.UserIdentity protocolObject)
        {
            this.AutoUser = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.AutoUser, o => new AutoUserSpecification(o).Freeze());
            this.UserName = protocolObject.UserName;
        }

        #endregion Constructors

        #region UserIdentity

        /// <summary>
        /// Gets the auto user under which the task is run.
        /// </summary>
        /// <remarks>
        /// The <see cref="UserName"/> and <see cref="AutoUser"/> properties are mutually exclusive; you must specify one 
        /// but not both.
        /// </remarks>
        public AutoUserSpecification AutoUser { get; }

        /// <summary>
        /// Gets the name of the user identity under which the task is run.
        /// </summary>
        /// <remarks>
        /// The <see cref="UserName"/> and <see cref="AutoUser"/> properties are mutually exclusive; you must specify one 
        /// but not both.
        /// </remarks>
        public string UserName { get; }

        #endregion // UserIdentity

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.UserIdentity ITransportObjectProvider<Models.UserIdentity>.GetTransportObject()
        {
            Models.UserIdentity result = new Models.UserIdentity()
            {
                AutoUser = UtilitiesInternal.CreateObjectWithNullCheck(this.AutoUser, (o) => o.GetTransportObject()),
                UserName = this.UserName,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}