// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the security settings like secure boot and vTPM used while creating the virtual machine.
    /// </summary>
    public partial class UefiSettings : ITransportObjectProvider<Models.UefiSettings>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> SecureBootEnabledProperty;
            public readonly PropertyAccessor<bool?> VTpmEnabledProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.SecureBootEnabledProperty = this.CreatePropertyAccessor<bool?>(nameof(SecureBootEnabled), BindingAccess.Read | BindingAccess.Write);
                this.VTpmEnabledProperty = this.CreatePropertyAccessor<bool?>(nameof(VTpmEnabled), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.UefiSettings protocolObject) : base(BindingState.Bound)
            {
                this.SecureBootEnabledProperty = this.CreatePropertyAccessor(
                    protocolObject.SecureBootEnabled,
                    nameof(SecureBootEnabled),
                    BindingAccess.Read | BindingAccess.Write);
                this.VTpmEnabledProperty = this.CreatePropertyAccessor(
                    protocolObject.VTpmEnabled,
                    nameof(VTpmEnabled),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="UefiSettings"/> class.
        /// </summary>
        public UefiSettings()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal UefiSettings(Models.UefiSettings protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region UefiSettings

        /// <summary>
        /// Gets or sets specifies whether secure boot should be enabled on the virtual machine.
        /// </summary>
        public bool? SecureBootEnabled
        {
            get { return this.propertyContainer.SecureBootEnabledProperty.Value; }
            set { this.propertyContainer.SecureBootEnabledProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets specifies whether vTPM should be enabled on the virtual machine.
        /// </summary>
        public bool? VTpmEnabled
        {
            get { return this.propertyContainer.VTpmEnabledProperty.Value; }
            set { this.propertyContainer.VTpmEnabledProperty.Value = value; }
        }

        #endregion // UefiSettings

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.UefiSettings ITransportObjectProvider<Models.UefiSettings>.GetTransportObject()
        {
            Models.UefiSettings result = new Models.UefiSettings()
            {
                SecureBootEnabled = this.SecureBootEnabled,
                VTpmEnabled = this.VTpmEnabled,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}