// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A scheduling policy for a compute node.
    /// </summary>
    public partial class TaskSchedulingPolicy : ITransportObjectProvider<Models.TaskSchedulingPolicy>, IPropertyMetadata
    {
        #region Constructors
        /// <summary>
        /// Initializes a new instance of the <see cref="TaskSchedulingPolicy"/> class.
        /// </summary>
        /// <param name='computeNodeFillType'>The fill type of scheduling policy.</param>
        public TaskSchedulingPolicy(
            Common.ComputeNodeFillType computeNodeFillType)
        {
            this.ComputeNodeFillType = computeNodeFillType;
        }

        internal TaskSchedulingPolicy(Models.TaskSchedulingPolicy protocolObject)
        {
            this.ComputeNodeFillType = UtilitiesInternal.MapEnum<Models.ComputeNodeFillType, Common.ComputeNodeFillType>(protocolObject.NodeFillType);
        }

        #endregion Constructors

        #region TaskSchedulingPolicy

        /// <summary>
        /// Gets the fill type of scheduling policy.
        /// </summary>
        /// <remarks>
        /// If not specified, the default is <see cref="Common.ComputeNodeFillType.Spread"/>.
        /// </remarks>
        public Common.ComputeNodeFillType ComputeNodeFillType { get; }

        #endregion // TaskSchedulingPolicy

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.TaskSchedulingPolicy ITransportObjectProvider<Models.TaskSchedulingPolicy>.GetTransportObject()
        {
            Models.TaskSchedulingPolicy result = new Models.TaskSchedulingPolicy()
            {
                NodeFillType = UtilitiesInternal.MapEnum<Common.ComputeNodeFillType, Models.ComputeNodeFillType>(this.ComputeNodeFillType),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}