// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A range of task ids that a <see cref="CloudTask"/> depends on. All tasks with ids in the range must complete successfully 
    /// before the dependent task can be scheduled.
    /// </summary>
    public partial class TaskIdRange : ITransportObjectProvider<Models.TaskIdRange>, IPropertyMetadata
    {
        #region Constructors

        internal TaskIdRange(Models.TaskIdRange protocolObject)
        {
            this.End = protocolObject.End;
            this.Start = protocolObject.Start;
        }

        #endregion Constructors

        #region TaskIdRange

        /// <summary>
        /// Gets the last task id in the range.
        /// </summary>
        /// <remarks>
        /// Ranges are inclusive. For example, if a task depends on a range with End 12, then task "12" must complete before 
        /// the task can be scheduled.
        /// </remarks>
        public int End { get; }

        /// <summary>
        /// Gets the first task id in the range.
        /// </summary>
        /// <remarks>
        /// Ranges are inclusive. For example, if a task depends on a range with Start 8, then task "8" must complete before 
        /// the task can be scheduled.
        /// </remarks>
        public int Start { get; }

        #endregion // TaskIdRange

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata

        #region Internal/private methods

        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.TaskIdRange ITransportObjectProvider<Models.TaskIdRange>.GetTransportObject()
        {
            Models.TaskIdRange result = new Models.TaskIdRange()
            {
                End = this.End,
                Start = this.Start,
            };

            return result;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects.
        /// </summary>
        internal static IList<TaskIdRange> ConvertFromProtocolCollection(IEnumerable<Models.TaskIdRange> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<TaskIdRange> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new TaskIdRange(o));

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, in a frozen state.
        /// </summary>
        internal static IList<TaskIdRange> ConvertFromProtocolCollectionAndFreeze(IEnumerable<Models.TaskIdRange> protoCollection)
        {
            ConcurrentChangeTrackedModifiableList<TaskIdRange> converted = UtilitiesInternal.CollectionToThreadSafeCollectionIModifiable(
                items: protoCollection,
                objectCreationFunc: o => new TaskIdRange(o).Freeze());

            converted = UtilitiesInternal.CreateObjectWithNullCheck(converted, o => o.Freeze());

            return converted;
        }

        /// <summary>
        /// Converts a collection of protocol layer objects to object layer collection objects, with each object marked readonly
        /// and returned as a readonly collection.
        /// </summary>
        internal static IReadOnlyList<TaskIdRange> ConvertFromProtocolCollectionReadOnly(IEnumerable<Models.TaskIdRange> protoCollection)
        {
            IReadOnlyList<TaskIdRange> converted =
                UtilitiesInternal.CreateObjectWithNullCheck(
                    UtilitiesInternal.CollectionToNonThreadSafeCollection(
                        items: protoCollection,
                        objectCreationFunc: o => new TaskIdRange(o).Freeze()), o => o.AsReadOnly());

            return converted;
        }

        #endregion // Internal/private methods
    }
}