// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information about a task failure.
    /// </summary>
    public partial class TaskFailureInformation : IPropertyMetadata
    {
        #region Constructors

        internal TaskFailureInformation(Models.TaskFailureInformation protocolObject)
        {
            this.Category = UtilitiesInternal.MapEnum<Models.ErrorCategory, Common.ErrorCategory>(protocolObject.Category);
            this.Code = protocolObject.Code;
            this.Details = NameValuePair.ConvertFromProtocolCollectionReadOnly(protocolObject.Details);
            this.Message = protocolObject.Message;
        }

        #endregion Constructors

        #region TaskFailureInformation

        /// <summary>
        /// Gets the category of the task error.
        /// </summary>
        public Common.ErrorCategory Category { get; }

        /// <summary>
        /// Gets a code for the task scheduling error. See <see cref="Common.TaskFailureInformationCodes"/> for possible 
        /// values.
        /// </summary>
        public string Code { get; }

        /// <summary>
        /// Gets a list of additional error details related to the error.
        /// </summary>
        public IReadOnlyList<NameValuePair> Details { get; }

        /// <summary>
        /// Gets a message describing the task error, intended to be suitable for display in a user interface.
        /// </summary>
        public string Message { get; }

        #endregion // TaskFailureInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}