// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The task counts for a job.
    /// </summary>
    public partial class TaskCountsResult : IPropertyMetadata
    {
        #region Constructors

        internal TaskCountsResult(Models.TaskCountsResult protocolObject)
        {
            this.TaskCounts = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.TaskCounts, o => new TaskCounts(o).Freeze());
            this.TaskSlotCounts = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.TaskSlotCounts, o => new TaskSlotCounts(o).Freeze());
        }

        #endregion Constructors

        #region TaskCountsResult

        /// <summary>
        /// Gets the number of Tasks per state
        /// </summary>
        public TaskCounts TaskCounts { get; }

        /// <summary>
        /// Gets the number of TaskSlots required by Tasks per state.
        /// </summary>
        public TaskSlotCounts TaskSlotCounts { get; }

        #endregion // TaskCountsResult

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}