// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Contains information about the container which a task is executing.
    /// </summary>
    public partial class TaskContainerExecutionInformation : IPropertyMetadata
    {
        #region Constructors

        internal TaskContainerExecutionInformation(Models.TaskContainerExecutionInformation protocolObject)
        {
            this.ContainerId = protocolObject.ContainerId;
            this.Error = protocolObject.Error;
            this.State = protocolObject.State;
        }

        #endregion Constructors

        #region TaskContainerExecutionInformation

        /// <summary>
        /// Gets the ID of the container.
        /// </summary>
        public string ContainerId { get; }

        /// <summary>
        /// Gets detailed error information about the container.
        /// </summary>
        /// <remarks>
        /// This is the detailed error string from the Docker service, if available. It is equivilant to the error field 
        /// returned by "docker inspect".
        /// </remarks>
        public string Error { get; }

        /// <summary>
        /// Gets the state of the container.
        /// </summary>
        /// <remarks>
        /// This is the state of the container according to the Docker service. It is equivilant to the status field returned 
        /// by "docker inspect".
        /// </remarks>
        public string State { get; }

        #endregion // TaskContainerExecutionInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}