// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Defines the constraints on a particular Azure Batch task.
    /// </summary>
    public partial class TaskConstraints : ITransportObjectProvider<Models.TaskConstraints>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<int?> MaxTaskRetryCountProperty;
            public readonly PropertyAccessor<TimeSpan?> MaxWallClockTimeProperty;
            public readonly PropertyAccessor<TimeSpan?> RetentionTimeProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.MaxTaskRetryCountProperty = this.CreatePropertyAccessor<int?>(nameof(MaxTaskRetryCount), BindingAccess.Read | BindingAccess.Write);
                this.MaxWallClockTimeProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(MaxWallClockTime), BindingAccess.Read | BindingAccess.Write);
                this.RetentionTimeProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(RetentionTime), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.TaskConstraints protocolObject) : base(BindingState.Bound)
            {
                this.MaxTaskRetryCountProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxTaskRetryCount,
                    nameof(MaxTaskRetryCount),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxWallClockTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxWallClockTime,
                    nameof(MaxWallClockTime),
                    BindingAccess.Read | BindingAccess.Write);
                this.RetentionTimeProperty = this.CreatePropertyAccessor(
                    protocolObject.RetentionTime,
                    nameof(RetentionTime),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="TaskConstraints"/> class.
        /// </summary>
        /// <param name='maxWallClockTime'>The maximum elapsed time that the task may run, measured from the time the task starts.</param>
        /// <param name='retentionTime'>The minimum time to retain the working directory for the task on the compute node where it ran, from the time 
        /// it completes execution. After this time, the Batch service may delete the working directory and all its contents.</param>
        /// <param name='maxTaskRetryCount'>The maximum number of retries for the task.</param>
        public TaskConstraints(
            TimeSpan? maxWallClockTime = default(TimeSpan?),
            TimeSpan? retentionTime = default(TimeSpan?),
            int? maxTaskRetryCount = default(int?))
        {
            this.propertyContainer = new PropertyContainer();
            this.MaxWallClockTime = maxWallClockTime;
            this.RetentionTime = retentionTime;
            this.MaxTaskRetryCount = maxTaskRetryCount;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="TaskConstraints"/> class.
        /// </summary>
        protected TaskConstraints()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal TaskConstraints(Models.TaskConstraints protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region TaskConstraints

        /// <summary>
        /// Gets or sets the maximum number of retries for the task.
        /// </summary>
        /// <remarks>
        /// Note that this value specifically controls the number of retries for the task executable due to a nonzero exit 
        /// code. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum 
        /// retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count 
        /// is 0, the Batch service does not retry the task after the first attempt. If the maximum retry count is -1, the 
        /// Batch service retries the task without limit. Resource files and application packages are only downloaded again 
        /// if the task is retried on a new compute node.
        /// </remarks>
        public int? MaxTaskRetryCount
        {
            get { return this.propertyContainer.MaxTaskRetryCountProperty.Value; }
            set { this.propertyContainer.MaxTaskRetryCountProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum elapsed time that the task may run, measured from the time the task starts.
        /// </summary>
        public TimeSpan? MaxWallClockTime
        {
            get { return this.propertyContainer.MaxWallClockTimeProperty.Value; }
            set { this.propertyContainer.MaxWallClockTimeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the minimum time to retain the working directory for the task on the compute node where it ran, 
        /// from the time it completes execution. After this time, the Batch service may delete the working directory and 
        /// all its contents.
        /// </summary>
        /// <remarks>
        /// The default is 7 days, i.e. the task directory will be retained for 7 days unless the compute node is removed 
        /// or the job is deleted.
        /// </remarks>
        public TimeSpan? RetentionTime
        {
            get { return this.propertyContainer.RetentionTimeProperty.Value; }
            set { this.propertyContainer.RetentionTimeProperty.Value = value; }
        }

        #endregion // TaskConstraints

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.TaskConstraints ITransportObjectProvider<Models.TaskConstraints>.GetTransportObject()
        {
            Models.TaskConstraints result = new Models.TaskConstraints()
            {
                MaxTaskRetryCount = this.MaxTaskRetryCount,
                MaxWallClockTime = this.MaxWallClockTime,
                RetentionTime = this.RetentionTime,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}