// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Information about an Azure Batch subtask.
    /// </summary>
    public partial class SubtaskInformation : IPropertyMetadata
    {
        #region Constructors

        internal SubtaskInformation(Models.SubtaskInformation protocolObject)
        {
            this.ComputeNodeInformation = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.NodeInfo, o => new ComputeNodeInformation(o).Freeze());
            this.ContainerInformation = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ContainerInfo, o => new TaskContainerExecutionInformation(o).Freeze());
            this.EndTime = protocolObject.EndTime;
            this.ExitCode = protocolObject.ExitCode;
            this.FailureInformation = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.FailureInfo, o => new TaskFailureInformation(o).Freeze());
            this.Id = protocolObject.Id;
            this.PreviousState = UtilitiesInternal.MapNullableEnum<Models.SubtaskState, Common.SubtaskState>(protocolObject.PreviousState);
            this.PreviousStateTransitionTime = protocolObject.PreviousStateTransitionTime;
            this.Result = UtilitiesInternal.MapNullableEnum<Models.TaskExecutionResult, Common.TaskExecutionResult>(protocolObject.Result);
            this.StartTime = protocolObject.StartTime;
            this.State = UtilitiesInternal.MapNullableEnum<Models.SubtaskState, Common.SubtaskState>(protocolObject.State);
            this.StateTransitionTime = protocolObject.StateTransitionTime;
        }

        #endregion Constructors

        #region SubtaskInformation

        /// <summary>
        /// Gets the information about the compute node on which the subtask ran.
        /// </summary>
        public ComputeNodeInformation ComputeNodeInformation { get; }

        /// <summary>
        /// Gets information about the container under which the task is executing.
        /// </summary>
        /// <remarks>
        /// This property is set only if the task runs in a container context.
        /// </remarks>
        public TaskContainerExecutionInformation ContainerInformation { get; }

        /// <summary>
        /// Gets the time at which the subtask completed. This property is set only if the subtask is in the <see cref="Common.SubtaskState.Completed"/> 
        /// state.
        /// </summary>
        public DateTime? EndTime { get; }

        /// <summary>
        /// Gets the exit code of the program specified on the subtask command line.
        /// </summary>
        /// <remarks>
        /// This property is only returned if the subtask is in the <see cref="Common.SubtaskState.Completed"/> state. The 
        /// exit code for a process reflects the specific convention implemented by the application developer for that process. 
        /// If you use the exit code value to make decisions in your code, be sure that you know the exit code convention 
        /// used by the application process. Note that the exit code may also be generated by the compute node operating 
        /// system, such as when a process is forcibly terminated.
        /// </remarks>
        public int? ExitCode { get; }

        /// <summary>
        /// Gets information describing the task failure, if any.
        /// </summary>
        public TaskFailureInformation FailureInformation { get; }

        /// <summary>
        /// Gets the id of the subtask.
        /// </summary>
        public int? Id { get; }

        /// <summary>
        /// Gets the previous state of the subtask. This property is not set if the subtask is in its initial <see cref="Common.SubtaskState.Running"/> 
        /// state.
        /// </summary>
        public Common.SubtaskState? PreviousState { get; }

        /// <summary>
        /// Gets the time at which the subtask entered its previous state. This property is not set if the subtask is in 
        /// its initial <see cref="Common.SubtaskState.Running"/> state.
        /// </summary>
        public DateTime? PreviousStateTransitionTime { get; }

        /// <summary>
        /// Gets the result of the task execution.
        /// </summary>
        /// <remarks>
        /// If the value is <see cref="Common.TaskExecutionResult.Failure" />, then the details of the failure can be found 
        /// in the <see cref="FailureInformation" /> property.
        /// </remarks>
        public Common.TaskExecutionResult? Result { get; }

        /// <summary>
        /// Gets the time at which the subtask started running. If the subtask has been restarted or retried, this is the 
        /// most recent time at which the subtask started running.
        /// </summary>
        public DateTime? StartTime { get; }

        /// <summary>
        /// Gets the current state of the subtask.
        /// </summary>
        public Common.SubtaskState? State { get; }

        /// <summary>
        /// Gets the time at which the subtask entered its current state.
        /// </summary>
        public DateTime? StateTransitionTime { get; }

        #endregion // SubtaskInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}