// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the detailed runtime information of the start task, including current state, error details, exit code, 
    /// start time, end time, etc.
    /// </summary>
    public partial class StartTaskInformation : IPropertyMetadata
    {
        #region Constructors

        internal StartTaskInformation(Models.StartTaskInformation protocolObject)
        {
            this.ContainerInformation = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.ContainerInfo, o => new TaskContainerExecutionInformation(o).Freeze());
            this.EndTime = protocolObject.EndTime;
            this.ExitCode = protocolObject.ExitCode;
            this.FailureInformation = UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.FailureInfo, o => new TaskFailureInformation(o).Freeze());
            this.LastRetryTime = protocolObject.LastRetryTime;
            this.Result = UtilitiesInternal.MapNullableEnum<Models.TaskExecutionResult, Common.TaskExecutionResult>(protocolObject.Result);
            this.RetryCount = protocolObject.RetryCount;
            this.StartTime = protocolObject.StartTime;
            this.State = UtilitiesInternal.MapEnum<Models.StartTaskState, Common.StartTaskState>(protocolObject.State);
        }

        #endregion Constructors

        #region StartTaskInformation

        /// <summary>
        /// Gets information about the container under which the task is executing.
        /// </summary>
        /// <remarks>
        /// This property is set only if the task runs in a container context.
        /// </remarks>
        public TaskContainerExecutionInformation ContainerInformation { get; }

        /// <summary>
        /// Gets the time at which the task completed.
        /// </summary>
        public DateTime? EndTime { get; }

        /// <summary>
        /// Gets the exit code of the program specified on the task command line.
        /// </summary>
        /// <remarks>
        /// This property is only returned if the task is in the <see cref="Common.StartTaskState.Completed"/> state. The 
        /// exit code for a process reflects the specific convention implemented by the application developer for that process. 
        /// If you use the exit code value to make decisions in your code, be sure that you know the exit code convention 
        /// used by the application process. Note that the exit code may also be generated by the compute node operating 
        /// system, such as when a process is forcibly terminated.
        /// </remarks>
        public int? ExitCode { get; }

        /// <summary>
        /// Gets information describing the task failure, if any.
        /// </summary>
        /// <remarks>
        /// This property is set only if the task is in the <see cref="Common.StartTaskState.Completed"/> state and encountered 
        /// a failure.
        /// </remarks>
        public TaskFailureInformation FailureInformation { get; }

        /// <summary>
        /// Gets the most recent time at which execution of the start task was retried by the Batch service.
        /// </summary>
        public DateTime? LastRetryTime { get; }

        /// <summary>
        /// Gets the result of the task execution.
        /// </summary>
        /// <remarks>
        /// If the value is <see cref="Common.TaskExecutionResult.Failure" />, then the details of the failure can be found 
        /// in the <see cref="FailureInformation" /> property.
        /// </remarks>
        public Common.TaskExecutionResult? Result { get; }

        /// <summary>
        /// Gets the number of times the start task has been retried by the Batch system.
        /// </summary>
        public int RetryCount { get; }

        /// <summary>
        /// Gets the time at which the task started running.
        /// </summary>
        public DateTime StartTime { get; }

        /// <summary>
        /// Gets the current running state of the start task.
        /// </summary>
        public Common.StartTaskState State { get; }

        #endregion // StartTaskInformation

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}