// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the service artifact reference id used to set same image version for all virtual machines in the scale 
    /// set when using 'latest' image version.
    /// </summary>
    public partial class ServiceArtifactReference : ITransportObjectProvider<Models.ServiceArtifactReference>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<string> IdProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.IdProperty = this.CreatePropertyAccessor<string>(nameof(Id), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.ServiceArtifactReference protocolObject) : base(BindingState.Bound)
            {
                this.IdProperty = this.CreatePropertyAccessor(
                    protocolObject.Id,
                    nameof(Id),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ServiceArtifactReference"/> class.
        /// </summary>
        /// <param name='id'>The service artifact reference id of ServiceArtifactReference</param>
        public ServiceArtifactReference(
            string id)
        {
            this.propertyContainer = new PropertyContainer();
            this.Id = id;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="ServiceArtifactReference"/> class.
        /// </summary>
        protected ServiceArtifactReference()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal ServiceArtifactReference(Models.ServiceArtifactReference protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region ServiceArtifactReference

        /// <summary>
        /// Gets or sets the service artifact reference id of ServiceArtifactReference
        /// </summary>
        /// <remarks>
        /// The service artifact reference id in the form of /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}
        /// </remarks>
        public string Id
        {
            get { return this.propertyContainer.IdProperty.Value; }
            set { this.propertyContainer.IdProperty.Value = value; }
        }

        #endregion // ServiceArtifactReference

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.ServiceArtifactReference ITransportObjectProvider<Models.ServiceArtifactReference>.GetTransportObject()
        {
            Models.ServiceArtifactReference result = new Models.ServiceArtifactReference()
            {
                Id = this.Id,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}