// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Specifies the security profile settings for the virtual machine or virtual machine scale set.
    /// </summary>
    public partial class SecurityProfile : ITransportObjectProvider<Models.SecurityProfile>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> EncryptionAtHostProperty;
            public readonly PropertyAccessor<Common.SecurityTypes?> SecurityTypeProperty;
            public readonly PropertyAccessor<UefiSettings> UefiSettingsProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.EncryptionAtHostProperty = this.CreatePropertyAccessor<bool?>(nameof(EncryptionAtHost), BindingAccess.Read | BindingAccess.Write);
                this.SecurityTypeProperty = this.CreatePropertyAccessor<Common.SecurityTypes?>(nameof(SecurityType), BindingAccess.Read | BindingAccess.Write);
                this.UefiSettingsProperty = this.CreatePropertyAccessor<UefiSettings>(nameof(UefiSettings), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.SecurityProfile protocolObject) : base(BindingState.Bound)
            {
                this.EncryptionAtHostProperty = this.CreatePropertyAccessor(
                    protocolObject.EncryptionAtHost,
                    nameof(EncryptionAtHost),
                    BindingAccess.Read | BindingAccess.Write);
                this.SecurityTypeProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.SecurityTypes, Common.SecurityTypes>(protocolObject.SecurityType),
                    nameof(SecurityType),
                    BindingAccess.Read | BindingAccess.Write);
                this.UefiSettingsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CreateObjectWithNullCheck(protocolObject.UefiSettings, o => new UefiSettings(o)),
                    nameof(UefiSettings),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="SecurityProfile"/> class.
        /// </summary>
        public SecurityProfile()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal SecurityProfile(Models.SecurityProfile protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region SecurityProfile

        /// <summary>
        /// Gets or sets this property can be used by user in the request to enable or disable the Host Encryption for the 
        /// virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp 
        /// disk at host itself.
        /// </summary>
        public bool? EncryptionAtHost
        {
            get { return this.propertyContainer.EncryptionAtHostProperty.Value; }
            set { this.propertyContainer.EncryptionAtHostProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets specifSpecifies the SecurityType of the virtual machine. It has to be set to any specified value 
        /// to enable UefiSettings.
        /// </summary>
        public Common.SecurityTypes? SecurityType
        {
            get { return this.propertyContainer.SecurityTypeProperty.Value; }
            set { this.propertyContainer.SecurityTypeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets specifies the security settings like secure boot and vTPM used while creating the virtual machine.
        /// </summary>
        public UefiSettings UefiSettings
        {
            get { return this.propertyContainer.UefiSettingsProperty.Value; }
            set { this.propertyContainer.UefiSettingsProperty.Value = value; }
        }

        #endregion // SecurityProfile

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.SecurityProfile ITransportObjectProvider<Models.SecurityProfile>.GetTransportObject()
        {
            Models.SecurityProfile result = new Models.SecurityProfile()
            {
                EncryptionAtHost = this.EncryptionAtHost,
                SecurityType = UtilitiesInternal.MapNullableEnum<Common.SecurityTypes, Models.SecurityTypes>(this.SecurityType),
                UefiSettings = UtilitiesInternal.CreateObjectWithNullCheck(this.UefiSettings, (o) => o.GetTransportObject()),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}