// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// A schedule.
    /// </summary>
    public partial class Schedule : ITransportObjectProvider<Models.Schedule>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<DateTime?> DoNotRunAfterProperty;
            public readonly PropertyAccessor<DateTime?> DoNotRunUntilProperty;
            public readonly PropertyAccessor<TimeSpan?> RecurrenceIntervalProperty;
            public readonly PropertyAccessor<TimeSpan?> StartWindowProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.DoNotRunAfterProperty = this.CreatePropertyAccessor<DateTime?>(nameof(DoNotRunAfter), BindingAccess.Read | BindingAccess.Write);
                this.DoNotRunUntilProperty = this.CreatePropertyAccessor<DateTime?>(nameof(DoNotRunUntil), BindingAccess.Read | BindingAccess.Write);
                this.RecurrenceIntervalProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(RecurrenceInterval), BindingAccess.Read | BindingAccess.Write);
                this.StartWindowProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(StartWindow), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.Schedule protocolObject) : base(BindingState.Bound)
            {
                this.DoNotRunAfterProperty = this.CreatePropertyAccessor(
                    protocolObject.DoNotRunAfter,
                    nameof(DoNotRunAfter),
                    BindingAccess.Read | BindingAccess.Write);
                this.DoNotRunUntilProperty = this.CreatePropertyAccessor(
                    protocolObject.DoNotRunUntil,
                    nameof(DoNotRunUntil),
                    BindingAccess.Read | BindingAccess.Write);
                this.RecurrenceIntervalProperty = this.CreatePropertyAccessor(
                    protocolObject.RecurrenceInterval,
                    nameof(RecurrenceInterval),
                    BindingAccess.Read | BindingAccess.Write);
                this.StartWindowProperty = this.CreatePropertyAccessor(
                    protocolObject.StartWindow,
                    nameof(StartWindow),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="Schedule"/> class.
        /// </summary>
        public Schedule()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal Schedule(Models.Schedule protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region Schedule

        /// <summary>
        /// Gets or sets the wall clock time after which no job will be scheduled under this job schedule.
        /// </summary>
        public DateTime? DoNotRunAfter
        {
            get { return this.propertyContainer.DoNotRunAfterProperty.Value; }
            set { this.propertyContainer.DoNotRunAfterProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the earliest wall clock time at which to schedule the first job under this job schedule
        /// </summary>
        public DateTime? DoNotRunUntil
        {
            get { return this.propertyContainer.DoNotRunUntilProperty.Value; }
            set { this.propertyContainer.DoNotRunUntilProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the time interval between the start times of two successive jobs under the job schedule.
        /// </summary>
        public TimeSpan? RecurrenceInterval
        {
            get { return this.propertyContainer.RecurrenceIntervalProperty.Value; }
            set { this.propertyContainer.RecurrenceIntervalProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the window of time within which a job must be started from the time the job schedule is ready to 
        /// be scheduled.
        /// </summary>
        public TimeSpan? StartWindow
        {
            get { return this.propertyContainer.StartWindowProperty.Value; }
            set { this.propertyContainer.StartWindowProperty.Value = value; }
        }

        #endregion // Schedule

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.Schedule ITransportObjectProvider<Models.Schedule>.GetTransportObject()
        {
            Models.Schedule result = new Models.Schedule()
            {
                DoNotRunAfter = this.DoNotRunAfter,
                DoNotRunUntil = this.DoNotRunUntil,
                RecurrenceInterval = this.RecurrenceInterval,
                StartWindow = this.StartWindow,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}