// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The configuration parameters used while performing a rolling upgrade.
    /// </summary>
    public partial class RollingUpgradePolicy : ITransportObjectProvider<Models.RollingUpgradePolicy>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<bool?> EnableCrossZoneUpgradeProperty;
            public readonly PropertyAccessor<int?> MaxBatchInstancePercentProperty;
            public readonly PropertyAccessor<int?> MaxUnhealthyInstancePercentProperty;
            public readonly PropertyAccessor<int?> MaxUnhealthyUpgradedInstancePercentProperty;
            public readonly PropertyAccessor<TimeSpan?> PauseTimeBetweenBatchesProperty;
            public readonly PropertyAccessor<bool?> PrioritizeUnhealthyInstancesProperty;
            public readonly PropertyAccessor<bool?> RollbackFailedInstancesOnPolicyBreachProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.EnableCrossZoneUpgradeProperty = this.CreatePropertyAccessor<bool?>(nameof(EnableCrossZoneUpgrade), BindingAccess.Read | BindingAccess.Write);
                this.MaxBatchInstancePercentProperty = this.CreatePropertyAccessor<int?>(nameof(MaxBatchInstancePercent), BindingAccess.Read | BindingAccess.Write);
                this.MaxUnhealthyInstancePercentProperty = this.CreatePropertyAccessor<int?>(nameof(MaxUnhealthyInstancePercent), BindingAccess.Read | BindingAccess.Write);
                this.MaxUnhealthyUpgradedInstancePercentProperty = this.CreatePropertyAccessor<int?>(nameof(MaxUnhealthyUpgradedInstancePercent), BindingAccess.Read | BindingAccess.Write);
                this.PauseTimeBetweenBatchesProperty = this.CreatePropertyAccessor<TimeSpan?>(nameof(PauseTimeBetweenBatches), BindingAccess.Read | BindingAccess.Write);
                this.PrioritizeUnhealthyInstancesProperty = this.CreatePropertyAccessor<bool?>(nameof(PrioritizeUnhealthyInstances), BindingAccess.Read | BindingAccess.Write);
                this.RollbackFailedInstancesOnPolicyBreachProperty = this.CreatePropertyAccessor<bool?>(nameof(RollbackFailedInstancesOnPolicyBreach), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.RollingUpgradePolicy protocolObject) : base(BindingState.Bound)
            {
                this.EnableCrossZoneUpgradeProperty = this.CreatePropertyAccessor(
                    protocolObject.EnableCrossZoneUpgrade,
                    nameof(EnableCrossZoneUpgrade),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxBatchInstancePercentProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxBatchInstancePercent,
                    nameof(MaxBatchInstancePercent),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxUnhealthyInstancePercentProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxUnhealthyInstancePercent,
                    nameof(MaxUnhealthyInstancePercent),
                    BindingAccess.Read | BindingAccess.Write);
                this.MaxUnhealthyUpgradedInstancePercentProperty = this.CreatePropertyAccessor(
                    protocolObject.MaxUnhealthyUpgradedInstancePercent,
                    nameof(MaxUnhealthyUpgradedInstancePercent),
                    BindingAccess.Read | BindingAccess.Write);
                this.PauseTimeBetweenBatchesProperty = this.CreatePropertyAccessor(
                    protocolObject.PauseTimeBetweenBatches,
                    nameof(PauseTimeBetweenBatches),
                    BindingAccess.Read | BindingAccess.Write);
                this.PrioritizeUnhealthyInstancesProperty = this.CreatePropertyAccessor(
                    protocolObject.PrioritizeUnhealthyInstances,
                    nameof(PrioritizeUnhealthyInstances),
                    BindingAccess.Read | BindingAccess.Write);
                this.RollbackFailedInstancesOnPolicyBreachProperty = this.CreatePropertyAccessor(
                    protocolObject.RollbackFailedInstancesOnPolicyBreach,
                    nameof(RollbackFailedInstancesOnPolicyBreach),
                    BindingAccess.Read | BindingAccess.Write);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="RollingUpgradePolicy"/> class.
        /// </summary>
        public RollingUpgradePolicy()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal RollingUpgradePolicy(Models.RollingUpgradePolicy protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region RollingUpgradePolicy

        /// <summary>
        /// Gets or sets allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration the 
        /// Update Domain and maxBatchInstancePercent to determine the batch size. This field is able to be set to true or 
        /// false only when using NodePlacementConfiguration as Zonal.
        /// </summary>
        public bool? EnableCrossZoneUpgrade
        {
            get { return this.propertyContainer.EnableCrossZoneUpgradeProperty.Value; }
            set { this.propertyContainer.EnableCrossZoneUpgradeProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum percent of total virtual machine instances that will be upgraded simultaneously by the 
        /// rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause 
        /// the percentage of instances in a batch to decrease to ensure higher reliability. The value of this field should 
        /// be between 5 and 100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent are assigned 
        /// with value, the value of maxBatchInstancePercent should not be more than maxUnhealthyInstancePercent.
        /// </summary>
        public int? MaxBatchInstancePercent
        {
            get { return this.propertyContainer.MaxBatchInstancePercentProperty.Value; }
            set { this.propertyContainer.MaxBatchInstancePercentProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum percentage of the total virtual machine instances in the scale set that can be simultaneously 
        /// unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine 
        /// health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. 
        /// The value of this field should be between 5 and 100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent 
        /// are assigned with value, the value of maxBatchInstancePercent should not be more than maxUnhealthyInstancePercent.
        /// </summary>
        public int? MaxUnhealthyInstancePercent
        {
            get { return this.propertyContainer.MaxUnhealthyInstancePercentProperty.Value; }
            set { this.propertyContainer.MaxUnhealthyInstancePercentProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy 
        /// state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling 
        /// update aborts. The value of this field should be between 0 and 100, inclusive.
        /// </summary>
        public int? MaxUnhealthyUpgradedInstancePercent
        {
            get { return this.propertyContainer.MaxUnhealthyUpgradedInstancePercentProperty.Value; }
            set { this.propertyContainer.MaxUnhealthyUpgradedInstancePercentProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets the wait time between completing the update for all virtual machines in one batch and starting the 
        /// next batch. The time duration should be specified in ISO 8601 format.
        /// </summary>
        public TimeSpan? PauseTimeBetweenBatches
        {
            get { return this.propertyContainer.PauseTimeBetweenBatchesProperty.Value; }
            set { this.propertyContainer.PauseTimeBetweenBatchesProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets upgrade all unhealthy instances in a scale set before any healthy instances.
        /// </summary>
        public bool? PrioritizeUnhealthyInstances
        {
            get { return this.propertyContainer.PrioritizeUnhealthyInstancesProperty.Value; }
            set { this.propertyContainer.PrioritizeUnhealthyInstancesProperty.Value = value; }
        }

        /// <summary>
        /// Gets or sets rollback failed instances to previous model if the Rolling Upgrade policy is violated.
        /// </summary>
        public bool? RollbackFailedInstancesOnPolicyBreach
        {
            get { return this.propertyContainer.RollbackFailedInstancesOnPolicyBreachProperty.Value; }
            set { this.propertyContainer.RollbackFailedInstancesOnPolicyBreachProperty.Value = value; }
        }

        #endregion // RollingUpgradePolicy

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.RollingUpgradePolicy ITransportObjectProvider<Models.RollingUpgradePolicy>.GetTransportObject()
        {
            Models.RollingUpgradePolicy result = new Models.RollingUpgradePolicy()
            {
                EnableCrossZoneUpgrade = this.EnableCrossZoneUpgrade,
                MaxBatchInstancePercent = this.MaxBatchInstancePercent,
                MaxUnhealthyInstancePercent = this.MaxUnhealthyInstancePercent,
                MaxUnhealthyUpgradedInstancePercent = this.MaxUnhealthyUpgradedInstancePercent,
                PauseTimeBetweenBatches = this.PauseTimeBetweenBatches,
                PrioritizeUnhealthyInstances = this.PrioritizeUnhealthyInstances,
                RollbackFailedInstancesOnPolicyBreach = this.RollbackFailedInstancesOnPolicyBreach,
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}