// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The resource statistics data for the pool.
    /// </summary>
    public partial class ResourceStatistics : IPropertyMetadata
    {
        #region Constructors

        internal ResourceStatistics(Models.ResourceStatistics protocolObject)
        {
            this.AverageCpuPercentage = protocolObject.AvgCPUPercentage;
            this.AverageDiskGiB = protocolObject.AvgDiskGiB;
            this.AverageMemoryGiB = protocolObject.AvgMemoryGiB;
            this.DiskReadGiB = protocolObject.DiskReadGiB;
            this.DiskReadIOps = protocolObject.DiskReadIOps;
            this.DiskWriteGiB = protocolObject.DiskWriteGiB;
            this.DiskWriteIOps = protocolObject.DiskWriteIOps;
            this.LastUpdateTime = protocolObject.LastUpdateTime;
            this.NetworkReadGiB = protocolObject.NetworkReadGiB;
            this.NetworkWriteGiB = protocolObject.NetworkWriteGiB;
            this.PeakDiskGiB = protocolObject.PeakDiskGiB;
            this.PeakMemoryGiB = protocolObject.PeakMemoryGiB;
            this.StartTime = protocolObject.StartTime;
        }

        #endregion Constructors

        #region ResourceStatistics

        /// <summary>
        /// Gets the average CPU usage across all compute nodes in the pool (percentage per compute node).
        /// </summary>
        public double AverageCpuPercentage { get; }

        /// <summary>
        /// Gets the average used disk space in gibibytes across all compute nodes in the pool.
        /// </summary>
        public double AverageDiskGiB { get; }

        /// <summary>
        /// Gets the average memory usage in gibibytes across all compute nodes in the pool.
        /// </summary>
        public double AverageMemoryGiB { get; }

        /// <summary>
        /// Gets the total amount of data in gibibytes of disk reads across all compute nodes in the pool.
        /// </summary>
        public double DiskReadGiB { get; }

        /// <summary>
        /// Gets the total number of disk read operations across all compute nodes in the pool.
        /// </summary>
        public long DiskReadIOps { get; }

        /// <summary>
        /// Gets the total amount of data in gibibytes of disk writes across all compute nodes in the pool.
        /// </summary>
        public double DiskWriteGiB { get; }

        /// <summary>
        /// Gets the total number of disk write operations across all compute nodes in the pool.
        /// </summary>
        public long DiskWriteIOps { get; }

        /// <summary>
        /// Gets the time at which the statistics were last updated. All statistics are limited to the range between <see 
        /// cref="StartTime"/> and this value.
        /// </summary>
        public DateTime LastUpdateTime { get; }

        /// <summary>
        /// Gets the total amount of data in gibibytes of network reads across all compute nodes in the pool.
        /// </summary>
        public double NetworkReadGiB { get; }

        /// <summary>
        /// Gets the total amount of data in gibibytes of network writes across all compute nodes in the pool.
        /// </summary>
        public double NetworkWriteGiB { get; }

        /// <summary>
        /// Gets the peak used disk space in gibibytes across all compute nodes in the pool.
        /// </summary>
        public double PeakDiskGiB { get; }

        /// <summary>
        /// Gets the peak memory usage in gibibytes across all compute nodes in the pool.
        /// </summary>
        public double PeakMemoryGiB { get; }

        /// <summary>
        /// Gets the start time of the time range covered by the statistics.
        /// </summary>
        public DateTime StartTime { get; }

        #endregion // ResourceStatistics

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}