// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Details about an output file upload operation, including under what conditions to perform the upload.
    /// </summary>
    public partial class PublicIPAddressConfiguration : ITransportObjectProvider<Models.PublicIPAddressConfiguration>, IPropertyMetadata
    {
        private class PropertyContainer : PropertyCollection
        {
            public readonly PropertyAccessor<IList<string>> IpAddressIdsProperty;
            public readonly PropertyAccessor<Common.IPAddressProvisioningType?> ProvisionProperty;

            public PropertyContainer() : base(BindingState.Unbound)
            {
                this.IpAddressIdsProperty = this.CreatePropertyAccessor<IList<string>>(nameof(IpAddressIds), BindingAccess.Read | BindingAccess.Write);
                this.ProvisionProperty = this.CreatePropertyAccessor<Common.IPAddressProvisioningType?>(nameof(Provision), BindingAccess.Read | BindingAccess.Write);
            }

            public PropertyContainer(Models.PublicIPAddressConfiguration protocolObject) : base(BindingState.Bound)
            {
                this.IpAddressIdsProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.CollectionToThreadSafeCollection(protocolObject.IpAddressIds, o => o),
                    nameof(IpAddressIds),
                    BindingAccess.Read);
                this.ProvisionProperty = this.CreatePropertyAccessor(
                    UtilitiesInternal.MapNullableEnum<Models.IPAddressProvisioningType, Common.IPAddressProvisioningType>(protocolObject.Provision),
                    nameof(Provision),
                    BindingAccess.Read);
            }
        }

        private readonly PropertyContainer propertyContainer;

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="PublicIPAddressConfiguration"/> class.
        /// </summary>
        /// <param name='provision'>The provisioning type for Public IP Addresses for the Pool.</param>
        public PublicIPAddressConfiguration(
            Common.IPAddressProvisioningType? provision)
        {
            this.propertyContainer = new PropertyContainer();
            this.Provision = provision;
        }

        /// <summary>
        /// Default constructor to support mocking the <see cref="PublicIPAddressConfiguration"/> class.
        /// </summary>
        protected PublicIPAddressConfiguration()
        {
            this.propertyContainer = new PropertyContainer();
        }

        internal PublicIPAddressConfiguration(Models.PublicIPAddressConfiguration protocolObject)
        {
            this.propertyContainer = new PropertyContainer(protocolObject);
        }

        #endregion Constructors

        #region PublicIPAddressConfiguration

        /// <summary>
        /// Gets or sets the list of public IPs which the Batch service will use when provisioning Compute Nodes.
        /// </summary>
        /// <remarks>
        /// The number of IPs specified here limits the maximum size of the Pool - 50 dedicated nodes or 20 low-priority 
        /// nodes can be allocated for each public IP. For example, a pool needing 150 dedicated VMs would need at least 
        /// 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        /// </remarks>
        public IList<string> IpAddressIds
        {
            get { return this.propertyContainer.IpAddressIdsProperty.Value; }
            set
            {
                this.propertyContainer.IpAddressIdsProperty.Value = ConcurrentChangeTrackedList<string>.TransformEnumerableToConcurrentList(value);
            }
        }

        /// <summary>
        /// Gets the provisioning type for Public IP Addresses for the Pool.
        /// </summary>
        /// <remarks>
        /// If not specified, the default value is BatchManaged.
        /// </remarks>
        public Common.IPAddressProvisioningType? Provision
        {
            get { return this.propertyContainer.ProvisionProperty.Value; }
            private set { this.propertyContainer.ProvisionProperty.Value = value; }
        }

        #endregion // PublicIPAddressConfiguration

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            get { return this.propertyContainer.HasBeenModified; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return this.propertyContainer.IsReadOnly; }
            set { this.propertyContainer.IsReadOnly = value; }
        }

        #endregion //IPropertyMetadata

        #region Internal/private methods
        /// <summary>
        /// Return a protocol object of the requested type.
        /// </summary>
        /// <returns>The protocol object of the requested type.</returns>
        Models.PublicIPAddressConfiguration ITransportObjectProvider<Models.PublicIPAddressConfiguration>.GetTransportObject()
        {
            Models.PublicIPAddressConfiguration result = new Models.PublicIPAddressConfiguration()
            {
                IpAddressIds = this.IpAddressIds,
                Provision = UtilitiesInternal.MapNullableEnum<Common.IPAddressProvisioningType, Models.IPAddressProvisioningType>(this.Provision),
            };

            return result;
        }


        #endregion // Internal/private methods
    }
}