// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

//
// This file was autogenerated by a tool.
// Do not modify it.
//

namespace Microsoft.Azure.Batch
{
    using Models = Microsoft.Azure.Batch.Protocol.Models;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// The usage metrics for a single pool in a certain time range.
    /// </summary>
    public partial class PoolUsageMetrics : IPropertyMetadata
    {
        #region Constructors

        internal PoolUsageMetrics(Models.PoolUsageMetrics protocolObject)
        {
            this.EndTime = protocolObject.EndTime;
            this.PoolId = protocolObject.PoolId;
            this.StartTime = protocolObject.StartTime;
            this.TotalCoreHours = protocolObject.TotalCoreHours;
            this.VirtualMachineSize = protocolObject.VmSize;
        }

        #endregion Constructors

        #region PoolUsageMetrics

        /// <summary>
        /// Gets the end time of the aggregation interval for this entry.
        /// </summary>
        public DateTime EndTime { get; }

        /// <summary>
        /// Gets the id of the pool whose metrics are aggregated in this entry.
        /// </summary>
        public string PoolId { get; }

        /// <summary>
        /// Gets the start time of the aggregation interval covered by this entry.
        /// </summary>
        public DateTime StartTime { get; }

        /// <summary>
        /// Gets the total core hours used in the pool during this aggregation interval.
        /// </summary>
        public double TotalCoreHours { get; }

        /// <summary>
        /// Gets the size of the virtual machines in the pool.  All virtual machines in a pool are the same size.
        /// </summary>
        /// <remarks>
        /// <para>For information about available sizes of virtual machines in pools, see Choose a VM size for compute nodes 
        /// in an Azure Batch pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).</para>
        /// </remarks>
        public string VirtualMachineSize { get; }

        #endregion // PoolUsageMetrics

        #region IPropertyMetadata

        bool IModifiable.HasBeenModified
        {
            //This class is compile time readonly so it cannot have been modified
            get { return false; }
        }

        bool IReadOnly.IsReadOnly
        {
            get { return true; }
            set
            {
                // This class is compile time readonly already
            }
        }

        #endregion // IPropertyMetadata
    }
}